/*
 * Decompiled with CFR 0.152.
 */
package pl.chilldev.commons.jsonrpc.netty;

import com.thetransactioncompany.jsonrpc2.JSONRPC2Error;
import com.thetransactioncompany.jsonrpc2.JSONRPC2ParseException;
import com.thetransactioncompany.jsonrpc2.JSONRPC2Request;
import com.thetransactioncompany.jsonrpc2.JSONRPC2Response;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pl.chilldev.commons.jsonrpc.daemon.ContextInterface;
import pl.chilldev.commons.jsonrpc.rpc.Dispatcher;

@ChannelHandler.Sharable
public class DispatcherHandler<ContextType extends ContextInterface>
extends ChannelInboundHandlerAdapter {
    private Logger logger = LoggerFactory.getLogger(DispatcherHandler.class);
    private ContextType context;
    private Dispatcher<? super ContextType> dispatcher;

    public DispatcherHandler(ContextType context, Dispatcher<? super ContextType> dispatcher) {
        this.context = context;
        this.dispatcher = dispatcher;
    }

    public void exceptionCaught(ChannelHandlerContext session, Throwable error) {
        this.logger.error("Session ID {}: connection exteption.", (Object)session.name(), (Object)error);
        session.writeAndFlush((Object)new JSONRPC2Response(JSONRPC2Error.INTERNAL_ERROR, null));
        session.close();
    }

    public void channelRead(ChannelHandlerContext session, Object message) {
        JSONRPC2Response response = null;
        try {
            JSONRPC2Request request = JSONRPC2Request.parse((String)message.toString());
            response = this.dispatchRequest(request);
        }
        catch (JSONRPC2ParseException error) {
            response = new JSONRPC2Response(JSONRPC2Error.PARSE_ERROR, null);
            this.logger.error("Could not parse JSON-RPC request.");
        }
        session.writeAndFlush((Object)response);
    }

    private JSONRPC2Response dispatchRequest(JSONRPC2Request request) {
        try {
            return this.dispatcher.dispatch(request, this.context);
        }
        catch (Exception error) {
            this.logger.error("Internal error.", (Throwable)error);
            return new JSONRPC2Response(JSONRPC2Error.INTERNAL_ERROR.appendMessage(": " + error.getMessage() + "."), request.getID());
        }
    }
}

