/*
 * Decompiled with CFR 0.152.
 */
package pl.chilldev.commons.jsonrpc.netty;

import com.thetransactioncompany.jsonrpc2.JSONRPC2ParseException;
import com.thetransactioncompany.jsonrpc2.JSONRPC2Request;
import com.thetransactioncompany.jsonrpc2.JSONRPC2Response;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.util.concurrent.GlobalEventExecutor;
import io.netty.util.concurrent.Promise;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Future;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pl.chilldev.commons.jsonrpc.rpc.ErrorCodes;

@ChannelHandler.Sharable
public class RequestHandler
extends ChannelInboundHandlerAdapter {
    private Logger logger = LoggerFactory.getLogger(RequestHandler.class);
    private Map<Object, Promise<JSONRPC2Response>> responses = new HashMap<Object, Promise<JSONRPC2Response>>();

    public Future<JSONRPC2Response> execute(JSONRPC2Request request) {
        Promise responder = GlobalEventExecutor.INSTANCE.newPromise();
        this.responses.put(request.getID(), (Promise<JSONRPC2Response>)responder);
        return responder;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void channelInactive(ChannelHandlerContext session) {
        Map<Object, Promise<JSONRPC2Response>> map = this.responses;
        synchronized (map) {
            for (Map.Entry<Object, Promise<JSONRPC2Response>> entry : this.responses.entrySet()) {
                this.logger.error("Terminating request ID {}: lost connection.", entry.getKey());
                entry.getValue().setFailure((Throwable)ErrorCodes.ERROR_CONNECTION.appendMessage(": lost connection."));
            }
            this.responses.clear();
        }
    }

    public void channelRead(ChannelHandlerContext session, Object message) throws JSONRPC2ParseException {
        try {
            JSONRPC2Response response = JSONRPC2Response.parse((String)message.toString());
            Object id = response.getID();
            if (this.responses.containsKey(id)) {
                this.responses.get(id).setSuccess((Object)response);
                this.responses.remove(id);
            } else {
                this.logger.warn("Session ID {}: response for unknown request ID {}.", (Object)session.name(), id);
            }
        }
        catch (JSONRPC2ParseException error) {
            this.logger.error("Could not parse JSON-RPC response.");
            throw error;
        }
    }

    public void exceptionCaught(ChannelHandlerContext session, Throwable error) throws Exception {
        this.logger.error("Session ID {}: connection exteption.", (Object)session.name(), (Object)error);
        session.close();
        throw new Exception(error);
    }
}

