/*
 * Decompiled with CFR 0.152.
 */
package pl.chilldev.commons.jsonrpc.netty;

import com.thetransactioncompany.jsonrpc2.JSONRPC2Message;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInitializer;
import io.netty.handler.codec.LineBasedFrameDecoder;
import io.netty.handler.codec.MessageToMessageEncoder;
import io.netty.handler.codec.string.StringDecoder;
import io.netty.handler.codec.string.StringEncoder;
import java.nio.charset.StandardCharsets;
import java.util.List;
import pl.chilldev.commons.jsonrpc.daemon.Listener;

public class StringChannelInitializer<ChannelType extends Channel>
extends ChannelInitializer<ChannelType> {
    private static final ChannelHandler STRING_DECODER = new StringDecoder(StandardCharsets.UTF_8);
    private static final ChannelHandler STRING_ENCODER = new StringEncoder(StandardCharsets.UTF_8);
    private static final ChannelHandler JSONRPC_ENCODER = new JsonRpc2MessageEncoder();
    private ChannelHandler handler;
    private Configuration config;

    public StringChannelInitializer(ChannelHandler handler, Configuration config) {
        this.handler = handler;
        this.config = config;
    }

    public void initChannel(ChannelType channel) {
        channel.pipeline().addLast(new ChannelHandler[]{new LineBasedFrameDecoder(this.config.getMaxPacketSize()), STRING_DECODER, STRING_ENCODER, JSONRPC_ENCODER, Listener.LOGGING_HANDLER, this.handler});
    }

    @ChannelHandler.Sharable
    private static class JsonRpc2MessageEncoder
    extends MessageToMessageEncoder<JSONRPC2Message> {
        private JsonRpc2MessageEncoder() {
        }

        protected void encode(ChannelHandlerContext context, JSONRPC2Message message, List<Object> out) {
            out.add(message.toJSONString() + "\n");
        }
    }

    @FunctionalInterface
    public static interface Configuration {
        public int getMaxPacketSize();
    }
}

