/*
 * Decompiled with CFR 0.152.
 */
package pl.chilldev.commons.jsonrpc.rpc.introspector;

import com.thetransactioncompany.jsonrpc2.JSONRPC2Error;
import com.thetransactioncompany.jsonrpc2.JSONRPC2Request;
import com.thetransactioncompany.jsonrpc2.JSONRPC2Response;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.Set;
import java.util.function.Function;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pl.chilldev.commons.jsonrpc.daemon.ContextInterface;
import pl.chilldev.commons.jsonrpc.json.ParamsRetriever;
import pl.chilldev.commons.jsonrpc.rpc.Dispatcher;
import pl.chilldev.commons.jsonrpc.rpc.DispatcherModule;
import pl.chilldev.commons.jsonrpc.rpc.handler.VersionHandler;
import pl.chilldev.commons.jsonrpc.rpc.introspector.JsonRpcCall;
import pl.chilldev.commons.jsonrpc.rpc.introspector.JsonRpcParam;
import pl.chilldev.commons.jsonrpc.rpc.introspector.ParameterProvider;

public class Introspector {
    private static final Function<Object, Object> IDENTITY_MAPPER = value -> value;
    private static Set<DispatcherModule> modules = new HashSet<DispatcherModule>();
    private Logger logger = LoggerFactory.getLogger(Introspector.class);
    private Map<Class<?>, ParameterProvider<?>> resolvers = new HashMap();
    private Map<Class<?>, Function<?, Object>> mappers = new HashMap();

    public <Type> void registerParameterProvider(Class<Type> type, ParameterProvider<? extends Type> resolver) {
        this.resolvers.put(type, resolver);
    }

    public <Type> void registerResultMapper(Class<Type> type, Function<? super Type, Object> mapper) {
        this.mappers.put(type, mapper);
    }

    public <ContextType extends ContextInterface> void register(Class<? super ContextType> facade, Dispatcher<? extends ContextType> dispatcher) {
        for (Method method : facade.getMethods()) {
            if (!method.isAnnotationPresent(JsonRpcCall.class)) continue;
            this.logger.debug("Found {}.{} method as JSON-RPC handler.", (Object)facade.getName(), (Object)method.getName());
            this.register(method, dispatcher);
        }
    }

    private <ContextType extends ContextInterface> void register(Method method, Dispatcher<? extends ContextType> dispatcher) {
        JsonRpcCall call = method.getAnnotation(JsonRpcCall.class);
        Parameter[] parameters = method.getParameters();
        ParameterProviderWrapper[] providers = new ParameterProviderWrapper[parameters.length];
        try {
            for (int i = 0; i < parameters.length; ++i) {
                providers[i] = this.createParameterProvider(parameters[i]);
            }
        }
        catch (IllegalArgumentException error) {
            throw new IllegalArgumentException(String.format("%s.%s() cann't be mapped to JSON-RPC handler.", method.getDeclaringClass().getName(), method.getName()), error);
        }
        Class<?> response = method.getReturnType();
        dispatcher.register(call.name().isEmpty() ? method.getName() : call.name(), new RequestHandler(method.getName(), method.getParameterTypes(), providers, this.mappers.containsKey(response) ? this.mappers.get(response) : IDENTITY_MAPPER));
    }

    private <Type> ParameterProviderWrapper<Type> createParameterProvider(Parameter parameter) {
        ParameterProvider<?> provider = this.resolvers.get(parameter.getType());
        if (provider == null) {
            throw new IllegalArgumentException(String.format("\"%s\" parameter type (%s) is not supported", parameter.getName(), parameter.getType().getName()));
        }
        String name = parameter.getName();
        String defaultValue = null;
        boolean optional = false;
        JsonRpcParam metadata = parameter.getAnnotation(JsonRpcParam.class);
        if (metadata != null) {
            name = metadata.name().isEmpty() ? name : metadata.name();
            optional = metadata.optional();
            defaultValue = metadata.defaultNull() ? null : metadata.defaultValue();
        }
        return this.createParameterProviderWrapper(provider, name, optional, defaultValue);
    }

    private <Type> ParameterProviderWrapper<Type> createParameterProviderWrapper(ParameterProvider<? extends Type> provider, String name, boolean optional, String defaultValue) {
        return params -> provider.getParam(name, params, optional, defaultValue);
    }

    public <ContextType extends ContextInterface> Dispatcher<ContextType> createDispatcher(Class<ContextType> type) {
        Dispatcher<ContextInterface> dispatcher = new Dispatcher<ContextInterface>();
        dispatcher.register("version", new VersionHandler());
        this.register(type, dispatcher);
        return dispatcher;
    }

    public static Introspector createDefault() {
        Introspector introspector = new Introspector();
        modules.forEach(module -> module.initializeIntrospector(introspector));
        return introspector;
    }

    static {
        ServiceLoader<DispatcherModule> loader = ServiceLoader.load(DispatcherModule.class);
        loader.forEach(modules::add);
    }

    static class RequestHandler<ContextType extends ContextInterface>
    implements Dispatcher.RequestHandler<ContextType> {
        private Logger logger = LoggerFactory.getLogger(RequestHandler.class);
        private String method;
        private Class<?>[] types;
        private ParameterProviderWrapper<?>[] params;
        private Function<Object, Object> mapper;

        RequestHandler(String method, Class<?>[] types, ParameterProviderWrapper<?>[] params, Function<Object, Object> mapper) {
            this.method = method;
            this.types = types;
            this.params = params;
            this.mapper = mapper;
        }

        @Override
        public JSONRPC2Response process(JSONRPC2Request request, ContextType context) throws JSONRPC2Error {
            ParamsRetriever retriever = new ParamsRetriever(request.getNamedParams());
            try {
                Object result;
                Method method = context.getClass().getMethod(this.method, this.types);
                Object[] arguments = new Object[this.types.length];
                for (int i = 0; i < this.params.length; ++i) {
                    arguments[i] = this.params[i].getParam(retriever);
                }
                try {
                    result = method.invoke(context, arguments);
                }
                catch (InvocationTargetException error) {
                    this.logger.error("Error executing \"{}\".", (Object)request.getMethod(), (Object)error);
                    throw error.getCause();
                }
                return method.getReturnType().equals(Void.TYPE) ? new JSONRPC2Response(request.getID()) : new JSONRPC2Response(this.mapper.apply(result), request.getID());
            }
            catch (JSONRPC2Error error) {
                throw error;
            }
            catch (Throwable error) {
                throw JSONRPC2Error.INTERNAL_ERROR.appendMessage(": " + error.getMessage());
            }
        }
    }

    @FunctionalInterface
    static interface ParameterProviderWrapper<Type> {
        public Type getParam(ParamsRetriever var1) throws JSONRPC2Error;
    }
}

