/*
 * Decompiled with CFR 0.152.
 */
package pl.chilldev.commons.service.api;

import com.thetransactioncompany.jsonrpc2.JSONRPC2Error;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.validation.ConstraintViolation;
import javax.validation.Validator;

public abstract class AbstractApiFacade {
    private Validator validator;

    public AbstractApiFacade(Validator validator) {
        this.validator = validator;
    }

    public static <Source, Destination> List<Destination> mapList(Collection<Source> source, Function<? super Source, ? extends Destination> mapper) {
        return source.stream().map(mapper).collect(Collectors.toList());
    }

    public <Type> void validateEntity(Type entity) throws JSONRPC2Error {
        Set errors = this.validator.validate(entity, new Class[0]);
        if (!errors.isEmpty()) {
            ArrayList<String> messages = new ArrayList<String>();
            for (ConstraintViolation error : errors) {
                messages.add(error.getMessage());
            }
            throw JSONRPC2Error.INVALID_PARAMS.appendMessage(String.format(": %s", String.join((CharSequence)", ", messages)));
        }
    }
}

