/*
 * Decompiled with CFR 0.152.
 */
package pl.chilldev.commons.service.config;

import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;
import java.util.UUID;
import javax.validation.Validation;
import javax.validation.Validator;
import net.minidev.json.JSONValue;
import net.minidev.json.reader.JsonWriterI;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.data.domain.Sort;
import org.springframework.transaction.annotation.AnnotationTransactionAttributeSource;
import org.springframework.transaction.interceptor.TransactionAttributeSource;
import pl.chilldev.commons.jsonrpc.json.ParamsRetriever;
import pl.chilldev.commons.jsonrpc.json.writer.DateTimeWriter;
import pl.chilldev.commons.jsonrpc.json.writer.SortWriter;
import pl.chilldev.commons.jsonrpc.json.writer.StringDumpingWriter;
import pl.chilldev.commons.jsonrpc.rpc.introspector.Introspector;

@Configuration
public class BaseApplicationConfiguration {
    @Bean
    public Introspector introspector() {
        return Introspector.createDefault();
    }

    @Bean
    public Validator validator() {
        return Validation.buildDefaultValidatorFactory().getValidator();
    }

    @Bean
    public TransactionAttributeSource transactionAttributeSource() {
        return new AnnotationTransactionAttributeSource();
    }

    static {
        ParamsRetriever.OBJECT_MAPPER.registerModule((Module)new JavaTimeModule());
        JSONValue.defaultWriter.registerWriter((JsonWriterI)new StringDumpingWriter(), new Class[]{UUID.class});
        JSONValue.defaultWriter.registerWriter((JsonWriterI)new SortWriter(), new Class[]{Sort.class});
        JSONValue.defaultWriter.registerWriter((JsonWriterI)new DateTimeWriter(DateTimeFormatter.ISO_OFFSET_DATE_TIME), new Class[]{OffsetDateTime.class});
    }
}

