/*
 * Decompiled with CFR 0.152.
 */
package pl.chilldev.commons.service.spring.config;

import com.mchange.v2.c3p0.ComboPooledDataSource;
import java.util.List;
import java.util.Properties;
import org.springframework.beans.MutablePropertyValues;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.RuntimeBeanReference;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.support.GenericBeanDefinition;
import org.springframework.beans.factory.xml.BeanDefinitionParser;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.data.jpa.repository.support.JpaRepositoryFactory;
import org.springframework.orm.jpa.JpaTransactionManager;
import org.springframework.orm.jpa.LocalContainerEntityManagerFactoryBean;
import org.springframework.orm.jpa.SharedEntityManagerCreator;
import org.springframework.orm.jpa.vendor.HibernateJpaVendorAdapter;
import org.w3c.dom.Element;

public abstract class AbstractDataSourceBeanDefinitionParser
implements BeanDefinitionParser {
    public static final String BEANNAME_TRANSACTIONMANAGER = "transactionManager";
    public static final String SEPARATOR_BEANNAME = ":";
    protected static final String ATTRIBUTE_NAME = "name";
    private static final String ATTRIBUTE_DRIVERCLASS = "driverClass";
    private static final String ATTRIBUTE_JDBCURL = "jdbcUrl";
    private static final String ATTRIBUTE_USER = "user";
    private static final String ATTRIBUTE_PASSWORD = "password";
    private static final String ATTRIBUTE_ACQUIREINCREMENT = "acquireIncrement";
    private static final String ATTRIBUTE_MINPOOLSIZE = "minPoolSize";
    private static final String ATTRIBUTE_MAXPOOLSIZE = "maxPoolSize";
    private static final String ATTRIBUTE_MAXIDLETIME = "maxIdleTime";
    private static final String ATTRIBUTE_INITIALPOOLSIZE = "initialPoolSize";
    private static final String ATTRIBUTE_HIBERNATEDIALECT = "hibernateDialect";
    private static final String ATTRIBUTE_HIBERNATEJDBCBATCHSIZE = "hibernateJdbcBatchSize";
    private static final String BEANNAME_DATASOURCE = "dataSource";
    private static final String BEANNAME_ENTITYMANAGERFACTORY = "entityManagerFactory";
    private static final String BEANNAME_ENTITYMANAGER = "entityManager";
    private static final String BEANNAME_REPOSITORYFACTORY = "repositoryFactory";
    private static final String METHOD_CREATESHAREDENTITYMANAGER = "createSharedEntityManager";
    private static final String METHOD_GETREPOSITORY = "getRepository";
    private static final String PROPERTY_PERSISTENCEUNITNAME = "persistenceUnitName";
    private static final String PROPERTY_DATASOURCE = "dataSource";
    private static final String PROPERTY_PACKAGESTOSCAN = "packagesToScan";
    private static final String PROPERTY_JPAVENDORADAPTER = "jpaVendorAdapter";
    private static final String PROPERTY_HIBERNATEHBM2DDLAUTO = "hibernate.hbm2ddl.auto";
    private static final String PROPERTY_HIBERNATEDIALECT = "hibernate.dialect";
    private static final String PROPERTY_HIBERNATEJDBCBATCHSIZE = "hibernate.jdbc.batch_size";
    private static final String PROPERTY_JPAPROPERTIES = "jpaProperties";

    public BeanDefinition parse(Element element, ParserContext parserContext) {
        String name = element.getAttribute(ATTRIBUTE_NAME);
        BeanDefinitionRegistry registry = parserContext.getRegistry();
        registry.registerBeanDefinition("dataSource:" + name, this.createDataSourceBeanDefinition(element));
        registry.registerBeanDefinition("entityManagerFactory:" + name, this.createEntityManagerFactoryBeanDefinition(name, element));
        registry.registerBeanDefinition("entityManager:" + name, this.createEntityManagerBeanDefinition(name));
        registry.registerBeanDefinition("repositoryFactory:" + name, this.createRepositoryFactoryBeanDefinition(name));
        registry.registerBeanDefinition("transactionManager:" + name, this.createTransactionManagerBeanDefinition(name));
        return null;
    }

    private BeanDefinition createDataSourceBeanDefinition(Element element) {
        GenericBeanDefinition bean = new GenericBeanDefinition();
        bean.setBeanClass(ComboPooledDataSource.class);
        MutablePropertyValues properties = bean.getPropertyValues();
        properties.addPropertyValue(ATTRIBUTE_DRIVERCLASS, (Object)element.getAttribute(ATTRIBUTE_DRIVERCLASS));
        properties.addPropertyValue(ATTRIBUTE_JDBCURL, (Object)element.getAttribute(ATTRIBUTE_JDBCURL));
        if (element.hasAttribute(ATTRIBUTE_USER)) {
            properties.addPropertyValue(ATTRIBUTE_USER, (Object)element.getAttribute(ATTRIBUTE_USER));
        }
        if (element.hasAttribute(ATTRIBUTE_PASSWORD)) {
            properties.addPropertyValue(ATTRIBUTE_PASSWORD, (Object)element.getAttribute(ATTRIBUTE_PASSWORD));
        }
        properties.addPropertyValue(ATTRIBUTE_ACQUIREINCREMENT, (Object)element.getAttribute(ATTRIBUTE_ACQUIREINCREMENT));
        properties.addPropertyValue(ATTRIBUTE_MINPOOLSIZE, (Object)element.getAttribute(ATTRIBUTE_MINPOOLSIZE));
        properties.addPropertyValue(ATTRIBUTE_MAXPOOLSIZE, (Object)element.getAttribute(ATTRIBUTE_MAXPOOLSIZE));
        properties.addPropertyValue(ATTRIBUTE_MAXIDLETIME, (Object)element.getAttribute(ATTRIBUTE_MAXIDLETIME));
        properties.addPropertyValue(ATTRIBUTE_INITIALPOOLSIZE, (Object)element.getAttribute(ATTRIBUTE_INITIALPOOLSIZE));
        return bean;
    }

    private BeanDefinition createEntityManagerFactoryBeanDefinition(String name, Element element) {
        GenericBeanDefinition bean = new GenericBeanDefinition();
        bean.setBeanClass(LocalContainerEntityManagerFactoryBean.class);
        MutablePropertyValues properties = bean.getPropertyValues();
        properties.addPropertyValue(PROPERTY_PERSISTENCEUNITNAME, (Object)name);
        properties.addPropertyValue("dataSource", (Object)new RuntimeBeanReference("dataSource:" + name));
        properties.addPropertyValue(PROPERTY_PACKAGESTOSCAN, this.getPackagesToScan());
        GenericBeanDefinition jpaVendorAdapterBean = new GenericBeanDefinition();
        jpaVendorAdapterBean.setBeanClass(HibernateJpaVendorAdapter.class);
        properties.addPropertyValue(PROPERTY_JPAVENDORADAPTER, (Object)jpaVendorAdapterBean);
        Properties jpaProperties = new Properties();
        jpaProperties.setProperty(PROPERTY_HIBERNATEHBM2DDLAUTO, "update");
        jpaProperties.setProperty(PROPERTY_HIBERNATEDIALECT, element.getAttribute(ATTRIBUTE_HIBERNATEDIALECT));
        jpaProperties.setProperty(PROPERTY_HIBERNATEJDBCBATCHSIZE, element.getAttribute(ATTRIBUTE_HIBERNATEJDBCBATCHSIZE));
        properties.addPropertyValue(PROPERTY_JPAPROPERTIES, (Object)jpaProperties);
        return bean;
    }

    private BeanDefinition createEntityManagerBeanDefinition(String name) {
        GenericBeanDefinition bean = new GenericBeanDefinition();
        bean.setBeanClass(SharedEntityManagerCreator.class);
        bean.setFactoryMethodName(METHOD_CREATESHAREDENTITYMANAGER);
        bean.getConstructorArgumentValues().addGenericArgumentValue((Object)new RuntimeBeanReference("entityManagerFactory:" + name));
        return bean;
    }

    private BeanDefinition createRepositoryFactoryBeanDefinition(String name) {
        GenericBeanDefinition bean = new GenericBeanDefinition();
        bean.setBeanClass(JpaRepositoryFactory.class);
        bean.getConstructorArgumentValues().addGenericArgumentValue((Object)new RuntimeBeanReference("entityManager:" + name));
        return bean;
    }

    private BeanDefinition createTransactionManagerBeanDefinition(String name) {
        GenericBeanDefinition bean = new GenericBeanDefinition();
        bean.setBeanClass(JpaTransactionManager.class);
        bean.getConstructorArgumentValues().addGenericArgumentValue((Object)new RuntimeBeanReference("entityManagerFactory:" + name));
        return bean;
    }

    protected BeanDefinition createRepositoryBeanDefinition(String name, Class<?> type) {
        GenericBeanDefinition bean = new GenericBeanDefinition();
        bean.setFactoryBeanName("repositoryFactory:" + name);
        bean.setFactoryMethodName(METHOD_GETREPOSITORY);
        bean.getConstructorArgumentValues().addGenericArgumentValue(type);
        return bean;
    }

    protected abstract List<String> getPackagesToScan();
}

