/*
 * Decompiled with CFR 0.152.
 */
package pl.chilldev.commons.service.spring.config;

import java.net.InetSocketAddress;
import org.springframework.beans.MutablePropertyValues;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.ConstructorArgumentValues;
import org.springframework.beans.factory.config.RuntimeBeanReference;
import org.springframework.beans.factory.support.GenericBeanDefinition;
import org.springframework.beans.factory.xml.BeanDefinitionParser;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.transaction.interceptor.TransactionProxyFactoryBean;
import org.w3c.dom.Element;

public abstract class AbstractListenerBeanDefinitionParser
implements BeanDefinitionParser {
    private static final String ATTRIBUTE_NAME = "name";
    private static final String ATTRIBUTE_HOST = "host";
    private static final String ATTRIBUTE_PORT = "port";
    private static final String ATTRIBUTE_MAXPACKETSIZE = "maxPacketSize";
    private static final String ATTRIBUTE_DATASOURCE = "dataSource";
    private static final String PROPERTY_ADDRESS = "address";
    private static final String PROPERTY_TARGET = "target";
    private static final String PROPERTY_TRANSACTIONMANAGER = "transactionManager";
    private static final String PROPERTY_TRANSACTIONATTRIBUTESOURCE = "transactionAttributeSource";
    private static final String METHOD_CREATELISTENER = "createListener";

    public BeanDefinition parse(Element element, ParserContext parserContext) {
        Class<?> beanClass = this.getFactoryClass();
        String name = element.getAttribute(ATTRIBUTE_NAME);
        GenericBeanDefinition listenerBean = new GenericBeanDefinition();
        listenerBean.setBeanClass(beanClass);
        listenerBean.setFactoryMethodName(METHOD_CREATELISTENER);
        listenerBean.setAutowireMode(3);
        ConstructorArgumentValues arguments = listenerBean.getConstructorArgumentValues();
        MutablePropertyValues properties = listenerBean.getPropertyValues();
        arguments.addGenericArgumentValue((Object)name);
        arguments.addGenericArgumentValue((Object)this.createApiFacadeProxyBeanDefinition(element.getAttribute(ATTRIBUTE_DATASOURCE)));
        properties.addPropertyValue(PROPERTY_ADDRESS, (Object)this.createAddressBeanDefinition(element));
        if (element.hasAttribute(ATTRIBUTE_MAXPACKETSIZE)) {
            properties.addPropertyValue(ATTRIBUTE_MAXPACKETSIZE, (Object)element.getAttribute(ATTRIBUTE_MAXPACKETSIZE));
        }
        parserContext.getRegistry().registerBeanDefinition(beanClass.getName() + ":" + name, (BeanDefinition)listenerBean);
        return null;
    }

    private BeanDefinition createAddressBeanDefinition(Element element) {
        GenericBeanDefinition addressBean = new GenericBeanDefinition();
        addressBean.setBeanClass(InetSocketAddress.class);
        ConstructorArgumentValues arguments = addressBean.getConstructorArgumentValues();
        arguments.addGenericArgumentValue((Object)element.getAttribute(ATTRIBUTE_HOST), "java.lang.String");
        arguments.addGenericArgumentValue((Object)element.getAttribute(ATTRIBUTE_PORT), "int");
        return addressBean;
    }

    private BeanDefinition createApiFacadeProxyBeanDefinition(String name) {
        GenericBeanDefinition proxyBean = new GenericBeanDefinition();
        proxyBean.setBeanClass(TransactionProxyFactoryBean.class);
        MutablePropertyValues properties = proxyBean.getPropertyValues();
        properties.addPropertyValue(PROPERTY_TARGET, (Object)this.createApiFacadeBeanDefinition(name));
        properties.addPropertyValue(PROPERTY_TRANSACTIONMANAGER, (Object)new RuntimeBeanReference("transactionManager:" + name));
        properties.addPropertyValue(PROPERTY_TRANSACTIONATTRIBUTESOURCE, (Object)new RuntimeBeanReference(PROPERTY_TRANSACTIONATTRIBUTESOURCE));
        return proxyBean;
    }

    protected abstract BeanDefinition createApiFacadeBeanDefinition(String var1);

    protected abstract Class<?> getFactoryClass();
}

