/*
 * Decompiled with CFR 0.152.
 */
package pl.chilldev.commons.text;

import java.util.HashMap;
import java.util.Map;
import pl.chilldev.commons.text.TextProcessingException;
import pl.chilldev.commons.text.formatter.FormatterInterface;

public class Formatter {
    private Map<String, FormatterInterface> formatters = new HashMap<String, FormatterInterface>();

    public void registerFormatter(String format, FormatterInterface handler) {
        this.formatters.put(format, handler);
    }

    public String transform(String format, String text) throws TextProcessingException {
        if (!this.formatters.containsKey(format)) {
            throw new TextProcessingException(String.format("No handler for format \"%s\" registred.", format));
        }
        return this.formatters.get(format).transform(text);
    }
}

