/*
 * Decompiled with CFR 0.152.
 */
package pl.chilldev.commons.text.html;

import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import pl.chilldev.commons.text.Formatter;
import pl.chilldev.commons.text.TextProcessingException;

public class Utils {
    public static final String SUFFIX_DEFAULT = "\u2026";
    public static final Pattern WORDBOUND_PATTERN = Pattern.compile("\\S\\s+\\S*?$", 64);
    public static final Pattern REGEX_FIRSTPARAGRAPH = Pattern.compile("<p(?: [^>]*)?>(.*?)</p>", 32);
    private static Formatter formatter = new Formatter();

    public static String firstParagraph(String text) {
        Matcher match = REGEX_FIRSTPARAGRAPH.matcher(text);
        return match.find() ? match.group(1) : "";
    }

    public static String truncate(String text, int length, String suffix, boolean wordBounds) {
        String part;
        Matcher matcher;
        if (text.length() <= length) {
            return text;
        }
        if (wordBounds && (matcher = WORDBOUND_PATTERN.matcher(part = text.substring(0, length + 2))).find()) {
            length = matcher.start() + 1;
        }
        return text.substring(0, length).trim() + suffix;
    }

    public static String truncate(String text, int length, String suffix) {
        return Utils.truncate(text, length, suffix, true);
    }

    public static String truncate(String text, int length, boolean wordBounds) {
        return Utils.truncate(text, length, SUFFIX_DEFAULT, wordBounds);
    }

    public static String truncate(String text, int length) {
        return Utils.truncate(text, length, SUFFIX_DEFAULT, true);
    }

    public static void setFormatter(Formatter formatter) {
        Utils.formatter = formatter;
    }

    public static String format(String format, String text) throws TextProcessingException {
        return formatter.transform(format, text);
    }

    public static String urlEncode(String value) throws UnsupportedEncodingException {
        return URLEncoder.encode(value, "UTF-8");
    }
}

