/*
 * Decompiled with CFR 0.152.
 */
package pl.chilldev.commons.web.filter;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.stereotype.Component;
import org.springframework.util.MimeType;
import org.springframework.web.servlet.View;
import org.springframework.web.servlet.ViewResolver;
import org.springframework.web.servlet.support.RequestContextUtils;
import org.springframework.web.util.ContentCachingResponseWrapper;

@Component(value="chillDevFrontPageFilter")
public class FrontPageFilter
implements Filter {
    private Logger logger = LoggerFactory.getLogger(FrontPageFilter.class);
    @Autowired
    private ViewResolver viewResolver;
    @Value(value="${chillDev.frontPageFilter.viewName}")
    private String viewName;

    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain chain) throws ServletException, IOException {
        if (servletRequest instanceof HttpServletRequest && servletResponse instanceof HttpServletResponse) {
            HttpServletRequest request = (HttpServletRequest)servletRequest;
            Object response = (HttpServletResponse)servletResponse;
            Enumeration accept = request.getHeaders("Accept");
            ArrayList accepts = Collections.list(accept);
            List mediaTypes = MediaType.parseMediaTypes(accepts);
            if (request.getMethod().equals(HttpMethod.GET.name())) {
                for (MediaType mediaType : mediaTypes) {
                    if (!MediaType.APPLICATION_XHTML_XML.isCompatibleWith(mediaType) && !MediaType.TEXT_HTML.isCompatibleWith(mediaType)) continue;
                    this.logger.trace("Rendering page response for {}.", (Object)request.getRequestURI());
                    response = new FrontHttpServletResponse((HttpServletResponse)response);
                    break;
                }
            }
            chain.doFilter((ServletRequest)request, (ServletResponse)response);
            if (response instanceof FrontHttpServletResponse) {
                try {
                    ((FrontHttpServletResponse)((Object)response)).buildResponse(this.viewResolver.resolveViewName(this.viewName, RequestContextUtils.getLocale((HttpServletRequest)request)), request);
                }
                catch (Exception error) {
                    this.logger.error("Error rendering {}: {}.", new Object[]{this.viewName, error.getMessage(), error});
                    throw new ServletException((Throwable)error);
                }
            }
        }
    }

    public void init(FilterConfig filterConfig) {
    }

    public void destroy() {
    }

    public void setViewResolver(ViewResolver viewResolver) {
        this.viewResolver = viewResolver;
    }

    public void setViewName(String viewName) {
        this.viewName = viewName;
    }

    private static class FrontHttpServletResponse
    extends ContentCachingResponseWrapper {
        FrontHttpServletResponse(HttpServletResponse response) {
            super(response);
        }

        public void sendError(int statusCode) {
            this.setStatus(statusCode);
        }

        public void sendError(int statusCode, String message) {
            this.setStatus(statusCode, message);
        }

        private void buildResponse(View view, HttpServletRequest request) throws IOException, ServletException {
            HttpServletResponse response = (HttpServletResponse)this.getResponse();
            if (this.getContentSize() == 0 || response.getStatus() < HttpStatus.BAD_REQUEST.value() && (response.containsHeader("Content-Disposition") || !response.containsHeader("Content-Type") || !MediaType.APPLICATION_JSON.isCompatibleWith(MimeType.valueOf((String)response.getContentType())))) {
                this.copyBodyToResponse();
                return;
            }
            HashMap<String, Object> data = new HashMap<String, Object>();
            data.put("responseStatus", response.getStatus());
            data.put("responseContent", new String(this.getContentAsByteArray(), StandardCharsets.UTF_8));
            try {
                view.render(data, request, response);
            }
            catch (Exception error) {
                throw new ServletException((Throwable)error);
            }
        }
    }
}

