/*
 * Decompiled with CFR 0.152.
 */
package pl.chilldev.commons.web.context;

import java.util.Optional;
import javax.servlet.ServletContext;
import org.springframework.web.context.ContextLoader;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.context.support.AnnotationConfigWebApplicationContext;

public class WebApplicationContextLoader
extends ContextLoader {
    private Class<?> configurationClass;
    private String[] profiles;
    private WebApplicationContext applicationContext;

    public WebApplicationContextLoader(Class<?> configurationClass, String ... profiles) {
        this.configurationClass = configurationClass;
        this.profiles = profiles;
    }

    protected WebApplicationContext createWebApplicationContext(ServletContext servletContext) {
        AnnotationConfigWebApplicationContext applicationContext = new AnnotationConfigWebApplicationContext();
        applicationContext.getEnvironment().setActiveProfiles(this.profiles);
        applicationContext.register(new Class[]{this.configurationClass});
        return applicationContext;
    }

    public WebApplicationContext initWebApplicationContext(ServletContext servletContext) {
        this.applicationContext = super.initWebApplicationContext(servletContext);
        return this.applicationContext;
    }

    public void closeWebApplicationContext() {
        Optional.ofNullable(this.applicationContext).map(WebApplicationContext::getServletContext).ifPresent(arg_0 -> ((WebApplicationContextLoader)this).closeWebApplicationContext(arg_0));
    }
}

