/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.xray.strategy;

import com.amazonaws.xray.entities.SearchPattern;
import com.amazonaws.xray.strategy.SegmentNamingStrategy;
import java.util.Optional;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DynamicSegmentNamingStrategy
implements SegmentNamingStrategy {
    private static final Log logger = LogFactory.getLog(DynamicSegmentNamingStrategy.class);
    private String recognizedHosts;
    private String fallbackName;

    public DynamicSegmentNamingStrategy(String fallbackName) {
        this(fallbackName, "*");
    }

    public DynamicSegmentNamingStrategy(String fallbackName, String recognizedHosts) {
        this.fallbackName = fallbackName;
        String overrideName = this.getOverrideName();
        if (null != overrideName) {
            this.fallbackName = this.getOverrideName();
            if (logger.isInfoEnabled()) {
                logger.info("Environment variable AWS_XRAY_TRACING_NAME or system property com.amazonaws.xray.strategy.tracingName set. Overriding DynamicSegmentNamingStrategy constructor argument. Segments generated with this strategy will be named: " + this.fallbackName + " when the host header is unavilable or does not match the provided recognizedHosts pattern.");
            }
        }
        this.recognizedHosts = recognizedHosts;
    }

    @Override
    public String nameForRequest(HttpServletRequest request) {
        Optional<String> hostHeaderValue = Optional.ofNullable(request.getHeader("Host"));
        if (hostHeaderValue.isPresent() && (null == this.recognizedHosts || SearchPattern.wildcardMatch(this.recognizedHosts, hostHeaderValue.get()))) {
            return hostHeaderValue.get();
        }
        return this.fallbackName;
    }
}

