/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.xray.strategy.sampling;

import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public class SamplingRequest {
    private static final String ARN_SEPARATOR = ":";
    private static final int ACCOUNT_INDEX = 4;
    private String roleARN;
    private String resourceARN;
    private String service;
    private String host;
    private String method;
    private String url;
    private String serviceType;
    private Map<String, String> attributes;

    public SamplingRequest(String roleARN, String resourceARN, String service, String host, String method, String url, String serviceType, Map<String, String> attributes) {
        Objects.requireNonNull(roleARN, "RoleARN can not be null");
        this.roleARN = roleARN;
        this.resourceARN = resourceARN;
        this.service = service;
        this.host = host;
        this.method = method;
        this.url = url;
        this.serviceType = serviceType;
        this.attributes = attributes != null ? attributes : Collections.emptyMap();
    }

    public SamplingRequest(String service, String host, String url, String method, String serviceType) {
        this.service = service;
        this.host = host;
        this.url = url;
        this.method = method;
        this.serviceType = serviceType;
    }

    public Optional<String> getAccountId() {
        String[] splits = this.roleARN.split(ARN_SEPARATOR, 6);
        if (splits.length < 6) {
            return Optional.empty();
        }
        return Optional.of(splits[4]);
    }

    public String getRoleARN() {
        return this.roleARN;
    }

    public Optional<String> getResourceARN() {
        return Optional.ofNullable(this.resourceARN);
    }

    public Optional<String> getService() {
        return Optional.ofNullable(this.service);
    }

    public Optional<String> getMethod() {
        return Optional.ofNullable(this.method);
    }

    public Optional<String> getUrl() {
        return Optional.ofNullable(this.url);
    }

    public Optional<String> getHost() {
        return Optional.ofNullable(this.host);
    }

    public Optional<String> getServiceType() {
        return Optional.ofNullable(this.serviceType);
    }

    public Map<String, String> getAttributes() {
        return this.attributes;
    }

    public void setServiceType(String serviceType) {
        this.serviceType = serviceType;
    }
}

