/*
 * Decompiled with CFR 0.152.
 */
package pl.datart.http4s.timer.newrelic;

import cats.effect.kernel.Sync;
import cats.implicits$;
import cats.syntax.ApplicativeErrorOps$;
import cats.syntax.FlatMapOps$;
import com.newrelic.api.agent.Agent;
import com.newrelic.api.agent.ExternalParameters;
import com.newrelic.api.agent.HttpParameters;
import com.newrelic.api.agent.NewRelic;
import com.newrelic.api.agent.Segment;
import com.newrelic.api.agent.Trace;
import com.newrelic.api.agent.TracedMethod;
import com.newrelic.api.agent.Transaction;
import com.newrelic.api.agent.TransactionNamePriority;
import fs2.Stream;
import fs2.Stream$;
import fs2.compat.NotGiven$;
import java.io.Serializable;
import java.net.URI;
import org.http4s.Request;
import org.http4s.Response;
import pl.datart.http4s.timer.RequestTimer;
import pl.datart.http4s.timer.newrelic.internal.Http4sRequest;
import pl.datart.http4s.timer.newrelic.internal.Http4sResponse;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.Tuple2$;
import scala.collection.immutable.Map;
import scala.jdk.CollectionConverters$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;
import scala.util.Try$;

public class NewRelicRequestTimer<F>
implements RequestTimer<F> {
    private final Sync<F> F;

    public NewRelicRequestTimer(Sync<F> F) {
        this.F = F;
    }

    @Trace(dispatcher=true)
    private Segment _startExternalAndGetSegment(String routesName, String requestName, ExternalParameters externalParameters) {
        Agent agent = NewRelic.getAgent();
        TracedMethod method = agent.getTracedMethod();
        method.reportAsExternal(externalParameters);
        method.setMetricName(new String[]{routesName});
        return agent.getTransaction().startSegment("External", requestName);
    }

    @Trace(dispatcher=true)
    private Segment _startWebTransactionAndGetSegment(String routesName) {
        NewRelic.getAgent().getTracedMethod().setMetricName(new String[]{routesName});
        return NewRelic.getAgent().getTransaction().startSegment("WebRequestPhase", "Headers");
    }

    public F setRequestInfo(String requestName, Transaction transaction, Request<F> request, Option<String> user) {
        return (F)this.F.delay(() -> NewRelicRequestTimer.setRequestInfo$$anonfun$1(requestName, transaction, request, user));
    }

    @Trace(async=true)
    private void _noticeError(Segment segment, Throwable t, Map<String, String> attrs) {
        segment.getTransaction().getToken().linkAndExpire();
        NewRelic.noticeError((Throwable)t, (java.util.Map)CollectionConverters$.MODULE$.MapHasAsJava(attrs).asJava(), (boolean)false);
    }

    public F noticeError(Segment segment, Throwable t, Map<String, String> attrs) {
        return (F)this.F.delay((Function0 & Serializable)() -> {
            this.noticeError$$anonfun$1(segment, t, attrs);
            return BoxedUnit.UNIT;
        });
    }

    public Map<String, String> noticeError$default$3() {
        return Predef$.MODULE$.Map().empty();
    }

    public F setResponseInfo(Segment segment, Either<Throwable, Response<F>> response) {
        Either<Throwable, Response<F>> either = response;
        if (either instanceof Left) {
            Throwable t = (Throwable)((Left)either).value();
            Object object = implicits$.MODULE$.catsSyntaxFlatMapOps(this.noticeError(segment, t, this.noticeError$default$3()), this.F);
            Object object2 = implicits$.MODULE$.catsSyntaxFlatMapOps(FlatMapOps$.MODULE$.$greater$greater$extension(object, () -> this.setResponseInfo$$anonfun$1(segment), this.F), this.F);
            return (F)FlatMapOps$.MODULE$.$greater$greater$extension(object2, () -> this.setResponseInfo$$anonfun$2(t), this.F);
        }
        if (either instanceof Right) {
            Response response2 = (Response)((Right)either).value();
            Http4sResponse<F> wrappedResponse = new Http4sResponse<F>(response2, this.F);
            return (F)this.F.delay(() -> NewRelicRequestTimer.setResponseInfo$$anonfun$3(segment, wrappedResponse));
        }
        throw new MatchError(either);
    }

    public <A> Stream<F, A> noticeErrorForStream(Segment segment, Stream<F, A> s) {
        return s.handleErrorWith((Function1 & Serializable)e -> Stream$.MODULE$.eval(this.noticeError(segment, (Throwable)e, this.noticeError$default$3())).drain());
    }

    public F endSegment(Segment segment) {
        return (F)this.F.delay((Function0 & Serializable)() -> {
            NewRelicRequestTimer.endSegment$$anonfun$1(segment);
            return BoxedUnit.UNIT;
        });
    }

    public F startBodySegment(Segment segment) {
        return (F)implicits$.MODULE$.catsSyntaxApply(this.F.delay(() -> NewRelicRequestTimer.startBodySegment$$anonfun$1(segment)), this.F).$less$times(this.endSegment(segment));
    }

    public Stream<F, Object> timeStream(Segment segment2, Stream<F, Object> body) {
        return Stream$.MODULE$.bracket(this.startBodySegment(segment2), (Function1 & Serializable)segment -> this.endSegment((Segment)segment)).flatMap((Function1 & Serializable)_$2 -> this.noticeErrorForStream((Segment)_$2, (Stream)body), NotGiven$.MODULE$.default());
    }

    public F time(String routesName, String requestName, Request<F> request, Option<String> user, F response) {
        return (F)implicits$.MODULE$.toFlatMapOps(this.F.delay(() -> this.time$$anonfun$1(routesName)), this.F).flatMap((Function1 & Serializable)segment -> implicits$.MODULE$.toFlatMapOps(this.setRequestInfo(new StringBuilder(3).append(requestName).append(" (").append(request.method().name()).append(")").toString(), segment.getTransaction(), request, user), this.F).flatMap((Function1 & Serializable)x$1 -> this.time$$anonfun$2$$anonfun$1(response, (Segment)segment, BoxesRunTime.unboxToBoolean((Object)x$1))));
    }

    public Option<String> time$default$4() {
        return None$.MODULE$;
    }

    public <A> F modifyExternalRequest(Segment segment, F completedRequest) {
        Object object = implicits$.MODULE$.catsSyntaxApplicativeError(completedRequest, this.F);
        return (F)implicits$.MODULE$.toFlatMapOps(ApplicativeErrorOps$.MODULE$.attempt$extension(object, this.F), this.F).flatMap((Function1 & Serializable)x$1 -> {
            Either either = x$1;
            if (either instanceof Left) {
                Throwable t = (Throwable)((Left)either).value();
                Object object = implicits$.MODULE$.catsSyntaxFlatMapOps(this.noticeError(segment, t, this.noticeError$default$3()), this.F);
                Object object2 = implicits$.MODULE$.catsSyntaxFlatMapOps(FlatMapOps$.MODULE$.$greater$greater$extension(object, () -> this.modifyExternalRequest$$anonfun$1$$anonfun$1(segment), this.F), this.F);
                return FlatMapOps$.MODULE$.$greater$greater$extension(object2, () -> this.modifyExternalRequest$$anonfun$1$$anonfun$2(t), this.F);
            }
            if (either instanceof Right) {
                Object result = ((Right)either).value();
                Object object = implicits$.MODULE$.catsSyntaxFlatMapOps(this.endSegment(segment), this.F);
                return FlatMapOps$.MODULE$.$greater$greater$extension(object, () -> this.modifyExternalRequest$$anonfun$1$$anonfun$3(result), this.F);
            }
            throw new MatchError((Object)either);
        });
    }

    public F timeExternal(String routesName, String requestName, Request<F> request, F response) {
        Option uri = Try$.MODULE$.apply(() -> NewRelicRequestTimer.$anonfun$1(request)).toOption();
        Option option = uri;
        if (option instanceof Some) {
            URI u = (URI)((Some)option).value();
            HttpParameters externalParameters = HttpParameters.library((String)"http4s").uri(u).procedure(request.method().name()).noInboundHeaders().build();
            return (F)implicits$.MODULE$.toFlatMapOps(this.F.delay(() -> this.timeExternal$$anonfun$1(routesName, requestName, externalParameters)), this.F).flatMap((Function1 & Serializable)segment -> implicits$.MODULE$.toFunctorOps(this.modifyExternalRequest((Segment)segment, response), this.F).map((Function1 & Serializable)completedRequest -> completedRequest));
        }
        if (None$.MODULE$.equals(option)) {
            return response;
        }
        throw new MatchError((Object)option);
    }

    public <A> F timeExternal(String routesName, String requestName, ExternalParameters externalParameters, F action) {
        return (F)implicits$.MODULE$.toFlatMapOps(this.F.delay(() -> this.timeExternal$$anonfun$3(routesName, requestName, externalParameters)), this.F).flatMap((Function1 & Serializable)segment -> implicits$.MODULE$.toFunctorOps(this.modifyExternalRequest((Segment)segment, action), this.F).map((Function1 & Serializable)completedRequest -> completedRequest));
    }

    private static final boolean setRequestInfo$$anonfun$1(String requestName$1, Transaction transaction$1, Request request$1, Option user$1) {
        transaction$1.setWebRequest(new Http4sRequest(request$1, (Option<String>)user$1));
        return transaction$1.setTransactionName(TransactionNamePriority.CUSTOM_HIGH, true, "WebRequest", new String[]{requestName$1});
    }

    private final void noticeError$$anonfun$1(Segment segment$1, Throwable t$1, Map attrs$1) {
        this._noticeError(segment$1, t$1, (Map<String, String>)attrs$1);
    }

    private final Object setResponseInfo$$anonfun$1(Segment segment$2) {
        return this.endSegment(segment$2);
    }

    private final Object setResponseInfo$$anonfun$2(Throwable t$2) {
        return this.F.raiseError((Object)t$2);
    }

    private static final Response setResponseInfo$$anonfun$3(Segment segment$3, Http4sResponse wrappedResponse$1) {
        segment$3.getTransaction().setWebResponse((com.newrelic.api.agent.Response)wrappedResponse$1);
        segment$3.getTransaction().addOutboundResponseHeaders();
        return wrappedResponse$1.response();
    }

    private static final void endSegment$$anonfun$1(Segment segment$5) {
        segment$5.end();
    }

    private static final Segment startBodySegment$$anonfun$1(Segment segment$6) {
        return segment$6.getTransaction().startSegment("WebRequestPhase", "Body");
    }

    private final Segment time$$anonfun$1(String routesName$1) {
        return this._startWebTransactionAndGetSegment(routesName$1);
    }

    private final /* synthetic */ Object time$$anonfun$2$$anonfun$1(Object response$2, Segment segment$7, boolean x$1) {
        boolean bl = x$1;
        Object object = implicits$.MODULE$.catsSyntaxApplicativeError(response$2, this.F);
        return implicits$.MODULE$.toFlatMapOps(ApplicativeErrorOps$.MODULE$.attempt$extension(object, this.F), this.F).flatMap((Function1 & Serializable)completedResponse -> implicits$.MODULE$.toFunctorOps(implicits$.MODULE$.toFunctorOps(this.setResponseInfo(segment$7, (Either<Throwable, Response<F>>)completedResponse), this.F).map((Function1 & Serializable)modifiedResponse -> {
            Response responseWithTimedBody = (Response)modifiedResponse.withBodyStream(this.timeStream(segment$7, modifiedResponse.body()));
            return Tuple2$.MODULE$.apply(modifiedResponse, (Object)responseWithTimedBody);
        }), this.F).map((Function1 & Serializable)x$1 -> {
            Tuple2 tuple2 = x$1;
            if (tuple2 != null) {
                Response modifiedResponse = (Response)tuple2._1();
                Response responseWithTimedBody = (Response)tuple2._2();
                return responseWithTimedBody;
            }
            throw new MatchError((Object)tuple2);
        }));
    }

    private final Object modifyExternalRequest$$anonfun$1$$anonfun$1(Segment segment$11) {
        return this.endSegment(segment$11);
    }

    private final Object modifyExternalRequest$$anonfun$1$$anonfun$2(Throwable t$3) {
        return this.F.raiseError((Object)t$3);
    }

    private final Object modifyExternalRequest$$anonfun$1$$anonfun$3(Object result$1) {
        return this.F.pure(result$1);
    }

    private static final URI $anonfun$1(Request request$3) {
        return URI.create(request$3.uri().toString());
    }

    private final Segment timeExternal$$anonfun$1(String routesName$2, String requestName$3, HttpParameters externalParameters$1) {
        return this._startExternalAndGetSegment(routesName$2, requestName$3, (ExternalParameters)externalParameters$1);
    }

    private final Segment timeExternal$$anonfun$3(String routesName$3, String requestName$4, ExternalParameters externalParameters$2) {
        return this._startExternalAndGetSegment(routesName$3, requestName$4, externalParameters$2);
    }
}

