/*
 * Decompiled with CFR 0.152.
 */
package us.fatehi.creditcardnumber;

import java.io.Serializable;
import java.util.Arrays;
import org.apache.commons.lang3.StringUtils;
import us.fatehi.creditcardnumber.AccountNumberInfo;
import us.fatehi.creditcardnumber.BaseRawData;
import us.fatehi.creditcardnumber.CardBrand;
import us.fatehi.creditcardnumber.DisposableStringData;
import us.fatehi.creditcardnumber.MajorIndustryIdentifier;
import us.fatehi.creditcardnumber.RawData;

public class AccountNumber
extends BaseRawData
implements RawData,
Serializable {
    private static final long serialVersionUID = -7012531091389412459L;
    private final DisposableStringData accountNumber;
    private final DisposableStringData issuerIdentificationNumber;
    private final DisposableStringData lastFourDigits;
    private final AccountNumberInfo accountNumberInfo;

    public AccountNumber() {
        this(null);
    }

    public AccountNumber(String rawAccountNumber) {
        super(rawAccountNumber);
        String accountNumberString = this.parseAccountNumber(StringUtils.trimToEmpty((String)rawAccountNumber));
        this.accountNumber = new DisposableStringData(accountNumberString);
        this.issuerIdentificationNumber = new DisposableStringData(StringUtils.rightPad((String)StringUtils.left((String)accountNumberString, (int)6), (int)6, (String)"0"));
        this.lastFourDigits = new DisposableStringData(StringUtils.leftPad((String)StringUtils.right((String)accountNumberString, (int)4), (int)4, (String)"0"));
        boolean passesLuhnCheck = this.luhnCheck();
        MajorIndustryIdentifier majorIndustryIdentifier = MajorIndustryIdentifier.from(accountNumberString);
        CardBrand cardBrand = CardBrand.from(accountNumberString);
        int accountNumberLength = accountNumberString.length();
        boolean isLengthValid = Arrays.asList(13, 14, 15, 16, 19).contains(accountNumberLength);
        boolean isPrimaryAccountNumberValid = this.hasAccountNumber() && isLengthValid && passesLuhnCheck && cardBrand != CardBrand.Unknown;
        boolean exceedsMaximumLength = accountNumberLength > 19;
        this.accountNumberInfo = new AccountNumberInfo(cardBrand, majorIndustryIdentifier, passesLuhnCheck, accountNumberLength, isLengthValid, isPrimaryAccountNumberValid, exceedsMaximumLength);
    }

    @Deprecated
    public void clear() {
        this.dispose();
    }

    @Deprecated
    public void clearIssuerIdentificationNumber() {
        this.disposeIssuerIdentificationNumber();
    }

    @Deprecated
    public void clearLastFourDigits() {
        this.disposeLastFourDigits();
    }

    public void dispose() {
        this.disposeRawData();
        this.disposeLastFourDigits();
        this.disposeIssuerIdentificationNumber();
        this.accountNumber.disposeData();
    }

    public void disposeIssuerIdentificationNumber() {
        this.disposeRawData();
        this.issuerIdentificationNumber.disposeData();
        this.accountNumber.disposeData(0, 6);
    }

    public void disposeLastFourDigits() {
        this.disposeRawData();
        this.lastFourDigits.disposeData();
        this.accountNumber.disposeData(this.accountNumber.length() - 4);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AccountNumber other = (AccountNumber)obj;
        if (this.accountNumber == null ? other.accountNumber != null : !this.accountNumber.equals(other.accountNumber)) {
            return false;
        }
        if (this.accountNumberInfo == null ? other.accountNumberInfo != null : !this.accountNumberInfo.equals(other.accountNumberInfo)) {
            return false;
        }
        if (this.issuerIdentificationNumber == null ? other.issuerIdentificationNumber != null : !this.issuerIdentificationNumber.equals(other.issuerIdentificationNumber)) {
            return false;
        }
        return !(this.lastFourDigits == null ? other.lastFourDigits != null : !this.lastFourDigits.equals(other.lastFourDigits));
    }

    @Override
    public boolean exceedsMaximumLength() {
        return this.accountNumberInfo.exceedsMaximumLength();
    }

    public String getAccountNumber() {
        return this.accountNumber.getData();
    }

    public int getAccountNumberLength() {
        return this.accountNumberInfo.getAccountNumberLength();
    }

    public CardBrand getCardBrand() {
        return this.accountNumberInfo.getCardBrand();
    }

    public String getIssuerIdentificationNumber() {
        return this.issuerIdentificationNumber.getData();
    }

    public String getLastFourDigits() {
        return this.lastFourDigits.getData();
    }

    public MajorIndustryIdentifier getMajorIndustryIdentifier() {
        return this.accountNumberInfo.getMajorIndustryIdentifier();
    }

    public boolean hasAccountNumber() {
        return this.accountNumber.hasData();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.accountNumber == null ? 0 : this.accountNumber.hashCode());
        result = 31 * result + (this.accountNumberInfo == null ? 0 : this.accountNumberInfo.hashCode());
        result = 31 * result + (this.issuerIdentificationNumber == null ? 0 : this.issuerIdentificationNumber.hashCode());
        result = 31 * result + (this.lastFourDigits == null ? 0 : this.lastFourDigits.hashCode());
        return result;
    }

    public boolean hasIssuerIdentificationNumber() {
        return this.issuerIdentificationNumber.hasData();
    }

    public boolean hasLastFourDigits() {
        return this.lastFourDigits.hasData();
    }

    public boolean isLengthValid() {
        return this.accountNumberInfo.isLengthValid();
    }

    public boolean isPrimaryAccountNumberValid() {
        return this.accountNumberInfo.isPrimaryAccountNumberValid();
    }

    public boolean passesLuhnCheck() {
        return this.accountNumberInfo.passesLuhnCheck();
    }

    public String toString() {
        if (this.hasAccountNumber()) {
            return this.getAccountNumber();
        }
        if (this.hasLastFourDigits()) {
            return String.format("%s-%s", new Object[]{this.accountNumberInfo.getCardBrand(), this.getLastFourDigits()});
        }
        return this.accountNumberInfo.getCardBrand().toString();
    }

    private boolean luhnCheck() {
        int length = this.accountNumber.length();
        int sum = 0;
        boolean alternate = false;
        for (int i = length - 1; i >= 0; --i) {
            int digit = Character.digit(this.accountNumber.charAt(i), 10);
            if (alternate) {
                digit = (digit *= 2) > 9 ? digit - 9 : digit;
            }
            sum += digit;
            alternate = !alternate;
        }
        boolean passesLuhnCheck = sum % 10 == 0;
        return passesLuhnCheck;
    }

    private String parseAccountNumber(String rawAccountNumber) {
        int codepoint;
        if (rawAccountNumber == null) {
            return "";
        }
        StringBuilder builder = new StringBuilder();
        int length = rawAccountNumber.length();
        for (int offset = 0; offset < length; offset += Character.charCount(codepoint)) {
            codepoint = rawAccountNumber.codePointAt(offset);
            if (!Character.isDigit(codepoint)) continue;
            int digit = Character.digit(codepoint, 10);
            builder.append(String.valueOf(digit));
        }
        return builder.toString();
    }
}

