/*
 * Decompiled with CFR 0.152.
 */
package us.fatehi.creditcardnumber;

import java.io.Serializable;
import us.fatehi.creditcardnumber.CardBrand;
import us.fatehi.creditcardnumber.MajorIndustryIdentifier;

final class AccountNumberInfo
implements Serializable {
    private static final long serialVersionUID = 2002490292247684624L;
    private final CardBrand cardBrand;
    private final MajorIndustryIdentifier majorIndustryIdentifier;
    private final boolean passesLuhnCheck;
    private final int accountNumberLength;
    private final boolean isLengthValid;
    private final boolean isPrimaryAccountNumberValid;
    private final boolean isExceedsMaximumLength;

    public AccountNumberInfo(CardBrand cardBrand, MajorIndustryIdentifier majorIndustryIdentifier, boolean passesLuhnCheck, int accountNumberLength, boolean isLengthValid, boolean isPrimaryAccountNumberValid, boolean isExceedsMaximumLength) {
        this.cardBrand = cardBrand;
        this.majorIndustryIdentifier = majorIndustryIdentifier;
        this.passesLuhnCheck = passesLuhnCheck;
        this.accountNumberLength = accountNumberLength;
        this.isLengthValid = isLengthValid;
        this.isPrimaryAccountNumberValid = isPrimaryAccountNumberValid;
        this.isExceedsMaximumLength = isExceedsMaximumLength;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AccountNumberInfo other = (AccountNumberInfo)obj;
        if (this.accountNumberLength != other.accountNumberLength) {
            return false;
        }
        if (this.cardBrand != other.cardBrand) {
            return false;
        }
        if (this.isPrimaryAccountNumberValid != other.isPrimaryAccountNumberValid) {
            return false;
        }
        if (this.majorIndustryIdentifier != other.majorIndustryIdentifier) {
            return false;
        }
        return this.passesLuhnCheck == other.passesLuhnCheck;
    }

    public boolean exceedsMaximumLength() {
        return this.isExceedsMaximumLength;
    }

    public int getAccountNumberLength() {
        return this.accountNumberLength;
    }

    public CardBrand getCardBrand() {
        return this.cardBrand;
    }

    public MajorIndustryIdentifier getMajorIndustryIdentifier() {
        return this.majorIndustryIdentifier;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.accountNumberLength;
        result = 31 * result + (this.cardBrand == null ? 0 : this.cardBrand.hashCode());
        result = 31 * result + (this.isPrimaryAccountNumberValid ? 1231 : 1237);
        result = 31 * result + (this.majorIndustryIdentifier == null ? 0 : this.majorIndustryIdentifier.hashCode());
        result = 31 * result + (this.passesLuhnCheck ? 1231 : 1237);
        return result;
    }

    public boolean isLengthValid() {
        return this.isLengthValid;
    }

    public boolean isPrimaryAccountNumberValid() {
        return this.isPrimaryAccountNumberValid;
    }

    public boolean passesLuhnCheck() {
        return this.passesLuhnCheck;
    }

    public String toString() {
        return "AccountNumberInfo [cardBrand=" + (Object)((Object)this.cardBrand) + ", majorIndustryIdentifier=" + (Object)((Object)this.majorIndustryIdentifier) + ", passesLuhnCheck=" + this.passesLuhnCheck + ", accountNumberLength=" + this.accountNumberLength + ", isLengthValid=" + this.isLengthValid + ", isPrimaryAccountNumberValid=" + this.isPrimaryAccountNumberValid + ", isExceedsMaximumLength=" + this.isExceedsMaximumLength + "]";
    }
}

