/*
 * Decompiled with CFR 0.152.
 */
package us.fatehi.creditcardnumber;

import java.io.Serializable;
import java.util.Date;
import us.fatehi.creditcardnumber.AccountNumber;
import us.fatehi.creditcardnumber.ExpirationDate;
import us.fatehi.creditcardnumber.Name;
import us.fatehi.creditcardnumber.ServiceCode;

public final class BankCard
implements Serializable {
    private static final long serialVersionUID = 6253084852668206154L;
    private final AccountNumber pan;
    private final Name name;
    private final ExpirationDate expirationDate;
    private final ServiceCode serviceCode;

    public BankCard() {
        this(null);
    }

    public BankCard(AccountNumber pan) {
        this(pan, null);
    }

    public BankCard(AccountNumber pan, ExpirationDate expirationDate) {
        this(pan, expirationDate, null);
    }

    public BankCard(AccountNumber pan, ExpirationDate expirationDate, Name name) {
        this(pan, expirationDate, name, null);
    }

    public BankCard(AccountNumber pan, ExpirationDate expirationDate, Name name, ServiceCode serviceCode) {
        this.pan = pan != null ? pan : new AccountNumber();
        this.name = name != null ? name : new Name();
        this.expirationDate = expirationDate != null ? expirationDate : new ExpirationDate();
        this.serviceCode = serviceCode != null ? serviceCode : new ServiceCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BankCard)) {
            return false;
        }
        BankCard other = (BankCard)obj;
        if (this.expirationDate == null ? other.expirationDate != null : !this.expirationDate.equals(other.expirationDate)) {
            return false;
        }
        if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
            return false;
        }
        return !(this.pan == null ? other.pan != null : !this.pan.equals(other.pan));
    }

    public String getAccountNumber() {
        return this.pan.getAccountNumber();
    }

    public String getCardHolderName() {
        return this.name.getFullName();
    }

    public ExpirationDate getExpirationDate() {
        return this.expirationDate;
    }

    public Date getExpirationDateAsDate() {
        return this.expirationDate.getExpirationDateAsDate();
    }

    public Name getName() {
        return this.name;
    }

    public AccountNumber getPrimaryAccountNumber() {
        return this.pan;
    }

    public ServiceCode getServiceCode() {
        return this.serviceCode;
    }

    public boolean hasExpirationDate() {
        return this.expirationDate != null && this.expirationDate.hasExpirationDate();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.expirationDate == null ? 0 : this.expirationDate.hashCode());
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        result = 31 * result + (this.pan == null ? 0 : this.pan.hashCode());
        return result;
    }

    public boolean hasName() {
        return this.name != null && this.name.hasName();
    }

    public boolean hasPrimaryAccountNumber() {
        return this.pan != null && this.pan.hasAccountNumber();
    }

    public boolean hasServiceCode() {
        return this.serviceCode != null && this.serviceCode.hasServiceCode();
    }

    public boolean isExpired() {
        return this.expirationDate.isExpired();
    }

    public String toString() {
        String NEWLINE = System.getProperty("line.separator");
        StringBuilder buffer = new StringBuilder();
        buffer.append("Bank Card Information: ").append(NEWLINE);
        if (this.hasPrimaryAccountNumber()) {
            buffer.append("  Raw Account Number: ");
            buffer.append(this.pan.getRawData()).append(NEWLINE);
            buffer.append("  Primary Account Number: ");
            buffer.append(this.pan).append(NEWLINE);
            buffer.append("    Major Industry Identifier: ");
            buffer.append((Object)this.pan.getMajorIndustryIdentifier()).append(NEWLINE);
            buffer.append("    Issuer Identification Number: ");
            buffer.append(this.pan.getIssuerIdentificationNumber()).append(NEWLINE);
            buffer.append("    Card Brand: ");
            buffer.append((Object)this.pan.getCardBrand()).append(NEWLINE);
            buffer.append("    Last Four Digits: ");
            buffer.append(this.pan.getLastFourDigits()).append(NEWLINE);
            buffer.append("    Passes Luhn Check? ");
            buffer.append(this.pan.passesLuhnCheck() ? "Yes" : "No").append(NEWLINE);
            buffer.append("    Is Primary Account Number Valid? ");
            buffer.append(this.pan.isPrimaryAccountNumberValid() ? "Yes" : "No").append(NEWLINE);
        }
        if (this.hasExpirationDate()) {
            buffer.append("  Expiration Date: ");
            buffer.append(this.expirationDate).append(NEWLINE);
            buffer.append("    Is Expired: ");
            buffer.append(this.expirationDate.isExpired() ? "Yes" : "No").append(NEWLINE);
        }
        if (this.hasName()) {
            buffer.append("  Name: ");
            buffer.append(this.getName()).append(NEWLINE);
        }
        if (this.hasServiceCode()) {
            ServiceCode serviceCode = this.getServiceCode();
            buffer.append("  Service Code: ");
            buffer.append(NEWLINE);
            buffer.append("    ");
            buffer.append(serviceCode.getServiceCode1()).append(NEWLINE);
            buffer.append("    ");
            buffer.append(serviceCode.getServiceCode2()).append(NEWLINE);
            buffer.append("    ");
            buffer.append(serviceCode.getServiceCode3()).append(NEWLINE);
        }
        return buffer.toString();
    }
}

