/*
 * Decompiled with CFR 0.152.
 */
package us.fatehi.creditcardnumber;

import java.util.Arrays;

public final class DisposableStringData
implements CharSequence {
    private final char[] data;

    public DisposableStringData(String data) {
        this.data = data != null ? data.toCharArray() : new char[0];
    }

    @Override
    public char charAt(int i) {
        return this.data[i];
    }

    public void disposeData() {
        Arrays.fill(this.data, '\u0000');
    }

    public void disposeData(int fromIndex) {
        Arrays.fill(this.data, Math.max(0, fromIndex), this.data.length, '\u0000');
    }

    public void disposeData(int fromIndex, int toIndex) {
        Arrays.fill(this.data, Math.max(0, fromIndex), Math.min(this.data.length, toIndex), '\u0000');
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        DisposableStringData other = (DisposableStringData)obj;
        return Arrays.equals(this.data, other.data);
    }

    public String getData() {
        if (this.hasData()) {
            return new String(this.data);
        }
        return null;
    }

    public boolean hasData() {
        return this.data.length > 0 && this.data[0] != '\u0000' && this.data[this.data.length - 1] != '\u0000';
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + Arrays.hashCode(this.data);
        return result;
    }

    @Override
    public int length() {
        return this.data.length;
    }

    @Override
    public CharSequence subSequence(int start, int end) {
        return this.toString().subSequence(start, end);
    }

    @Override
    public String toString() {
        if (this.hasData()) {
            return new String(this.data);
        }
        return "";
    }
}

