/*
 * Decompiled with CFR 0.152.
 */
package us.fatehi.creditcardnumber;

import java.io.Serializable;
import java.util.Date;
import org.apache.commons.lang3.StringUtils;
import org.threeten.bp.Instant;
import org.threeten.bp.LocalDate;
import org.threeten.bp.LocalDateTime;
import org.threeten.bp.YearMonth;
import org.threeten.bp.ZoneId;
import org.threeten.bp.chrono.ChronoLocalDate;
import org.threeten.bp.format.DateTimeFormatter;
import org.threeten.bp.temporal.ChronoUnit;
import org.threeten.bp.temporal.TemporalUnit;
import us.fatehi.creditcardnumber.BaseRawData;
import us.fatehi.creditcardnumber.Utility;

public final class ExpirationDate
extends BaseRawData
implements Serializable {
    private static final DateTimeFormatter formatter = DateTimeFormatter.ofPattern((String)"yyMM");
    private static final long serialVersionUID = 422773685360335298L;
    private final YearMonth expirationDate;

    public ExpirationDate() {
        this((String)null);
    }

    public ExpirationDate(Date date) {
        super(null);
        this.expirationDate = date != null ? YearMonth.of((int)(date.getYear() + 1900), (int)(date.getMonth() + 1)) : null;
    }

    public ExpirationDate(int year, int month) {
        super(null);
        this.expirationDate = YearMonth.of((int)year, (int)month);
    }

    public ExpirationDate(String rawExpirationDate) {
        super(rawExpirationDate);
        YearMonth expirationDate;
        String expirationDateString = Utility.non_digit.matcher(StringUtils.trimToEmpty((String)rawExpirationDate)).replaceAll("");
        try {
            expirationDate = YearMonth.parse((CharSequence)expirationDateString, (DateTimeFormatter)formatter);
        }
        catch (Exception e) {
            expirationDate = null;
        }
        this.expirationDate = expirationDate;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ExpirationDate)) {
            return false;
        }
        ExpirationDate other = (ExpirationDate)obj;
        return !(this.expirationDate == null ? other.expirationDate != null : !this.expirationDate.equals((Object)other.expirationDate));
    }

    @Override
    public boolean exceedsMaximumLength() {
        return StringUtils.trimToEmpty((String)this.getRawData()).length() > 4;
    }

    public YearMonth getExpirationDate() {
        return this.expirationDate;
    }

    public Date getExpirationDateAsDate() {
        if (this.hasExpirationDate()) {
            LocalDateTime endOfMonth = this.expirationDate.atEndOfMonth().atStartOfDay().plus(1L, (TemporalUnit)ChronoUnit.DAYS).minus(1L, (TemporalUnit)ChronoUnit.NANOS);
            Instant instant = endOfMonth.atZone(ZoneId.systemDefault()).toInstant();
            Date date = new Date(instant.toEpochMilli());
            return date;
        }
        return null;
    }

    public boolean hasExpirationDate() {
        return this.expirationDate != null;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.expirationDate == null ? 0 : this.expirationDate.hashCode());
        return result;
    }

    public boolean isExpired() {
        if (!this.hasExpirationDate()) {
            return true;
        }
        return this.expirationDate.atEndOfMonth().isBefore((ChronoLocalDate)LocalDate.now());
    }

    public String toString() {
        if (this.hasExpirationDate()) {
            return this.expirationDate.toString();
        }
        return "";
    }
}

