/*
 * Decompiled with CFR 0.152.
 */
package us.fatehi.creditcardnumber;

import java.io.Serializable;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.text.WordUtils;
import us.fatehi.creditcardnumber.BaseRawData;

public final class Name
extends BaseRawData
implements Serializable {
    private static final long serialVersionUID = 6735627336462134892L;
    private final String firstName;
    private final String lastName;

    public Name() {
        this(null);
    }

    public Name(String rawName) {
        super(rawName);
        String[] splitName = StringUtils.trimToEmpty((String)rawName).split("/");
        this.firstName = this.name(splitName, 1);
        this.lastName = this.name(splitName, 0);
    }

    public Name(String firstName, String lastName) {
        super(null);
        this.firstName = firstName;
        this.lastName = lastName;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Name)) {
            return false;
        }
        Name other = (Name)obj;
        if (this.firstName == null ? other.firstName != null : !this.firstName.equalsIgnoreCase(other.firstName)) {
            return false;
        }
        return !(this.lastName == null ? other.lastName != null : !this.lastName.equalsIgnoreCase(other.lastName));
    }

    @Override
    public boolean exceedsMaximumLength() {
        return StringUtils.trimToEmpty((String)this.getRawData()).length() > 26;
    }

    public String getFirstName() {
        return this.firstName;
    }

    public String getFullName() {
        StringBuilder buffer = new StringBuilder();
        if (this.hasFirstName()) {
            buffer.append(StringUtils.trimToEmpty((String)this.firstName));
        }
        if (this.hasFullName()) {
            buffer.append(" ");
        }
        if (this.hasLastName()) {
            buffer.append(StringUtils.trimToEmpty((String)this.lastName));
        }
        return buffer.toString();
    }

    public String getLastName() {
        return this.lastName;
    }

    public boolean hasFirstName() {
        return !StringUtils.isBlank((CharSequence)this.firstName);
    }

    public boolean hasFullName() {
        return this.hasFirstName() && this.hasLastName();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.firstName == null ? 0 : this.firstName.hashCode());
        result = 31 * result + (this.lastName == null ? 0 : this.lastName.hashCode());
        return result;
    }

    public boolean hasLastName() {
        return !StringUtils.isBlank((CharSequence)this.lastName);
    }

    public boolean hasName() {
        return this.hasFirstName() || this.hasLastName();
    }

    public String toString() {
        return this.getFullName();
    }

    private String name(String[] splitName, int position) {
        String name = splitName.length > position ? WordUtils.capitalizeFully((String)StringUtils.trimToEmpty((String)splitName[position]), (char[])new char[]{'.', '\'', ' '}) : "";
        return name;
    }
}

