/*
 * Decompiled with CFR 0.152.
 */
package us.fatehi.creditcardnumber;

import java.io.Serializable;
import org.apache.commons.lang3.StringUtils;
import us.fatehi.creditcardnumber.BaseRawData;
import us.fatehi.creditcardnumber.ServiceCode1;
import us.fatehi.creditcardnumber.ServiceCode2;
import us.fatehi.creditcardnumber.ServiceCode3;
import us.fatehi.creditcardnumber.ServiceCodeType;
import us.fatehi.creditcardnumber.Utility;

public class ServiceCode
extends BaseRawData
implements Serializable {
    private static final long serialVersionUID = -5127753346282374841L;
    private final String serviceCode;
    private final ServiceCode1 serviceCode1;
    private final ServiceCode2 serviceCode2;
    private final ServiceCode3 serviceCode3;

    public ServiceCode() {
        this(null);
    }

    public ServiceCode(String rawServiceCode) {
        super(rawServiceCode);
        this.serviceCode = Utility.non_digit.matcher(StringUtils.trimToEmpty((String)rawServiceCode)).replaceAll("");
        this.serviceCode1 = this.serviceCode(0, ServiceCode1.unknown);
        this.serviceCode2 = this.serviceCode(1, ServiceCode2.unknown);
        this.serviceCode3 = this.serviceCode(2, ServiceCode3.unknown);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ServiceCode)) {
            return false;
        }
        ServiceCode other = (ServiceCode)obj;
        return !(this.serviceCode == null ? other.serviceCode != null : !this.serviceCode.equals(other.serviceCode));
    }

    @Override
    public boolean exceedsMaximumLength() {
        return StringUtils.trimToEmpty((String)this.getRawData()).length() > 3;
    }

    public String getServiceCode() {
        return this.serviceCode;
    }

    public ServiceCode1 getServiceCode1() {
        return this.serviceCode1;
    }

    public ServiceCode2 getServiceCode2() {
        return this.serviceCode2;
    }

    public ServiceCode3 getServiceCode3() {
        return this.serviceCode3;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.serviceCode == null ? 0 : this.serviceCode.hashCode());
        return result;
    }

    public boolean hasServiceCode() {
        return this.serviceCode1 != ServiceCode1.unknown && this.serviceCode2 != ServiceCode2.unknown && this.serviceCode3 != ServiceCode3.unknown;
    }

    public String toString() {
        return this.serviceCode;
    }

    private <S extends Enum<S>> S serviceCode(int position, S defaultServiceCode) {
        if (this.serviceCode.length() > position) {
            Enum[] serviceCodes;
            int value = Character.digit(this.serviceCode.charAt(position), 10);
            for (Enum serviceCode : serviceCodes = (Enum[])defaultServiceCode.getDeclaringClass().getEnumConstants()) {
                if (((ServiceCodeType)((Object)serviceCode)).getValue() != value) continue;
                return (S)serviceCode;
            }
        }
        return defaultServiceCode;
    }
}

