/*
 * Decompiled with CFR 0.152.
 */
package pl.droidsonroids.jspoon;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import pl.droidsonroids.jspoon.HtmlClassField;
import pl.droidsonroids.jspoon.HtmlField;
import pl.droidsonroids.jspoon.HtmlListField;
import pl.droidsonroids.jspoon.HtmlSimpleField;
import pl.droidsonroids.jspoon.Jspoon;
import pl.droidsonroids.jspoon.Utils;
import pl.droidsonroids.jspoon.annotation.Selector;
import pl.droidsonroids.jspoon.exception.ConstrucorNotFoundException;
import pl.droidsonroids.jspoon.exception.ObjectCreationException;

public class HtmlAdapter<T> {
    private Jspoon jspoon;
    private Class<T> clazz;
    private Map<String, HtmlField<T>> htmlFieldCache;

    HtmlAdapter(Jspoon jspoon, Class<T> clazz) {
        Field[] declaredFields;
        this.jspoon = jspoon;
        this.clazz = clazz;
        this.htmlFieldCache = new LinkedHashMap<String, HtmlField<T>>();
        for (Field field : declaredFields = clazz.getDeclaredFields()) {
            Class<?> fieldClass = field.getType();
            Selector selector = field.getAnnotation(Selector.class);
            if (selector == null) {
                selector = fieldClass.getAnnotation(Selector.class);
            }
            if (selector == null && List.class.isAssignableFrom(fieldClass)) {
                selector = this.getSelectorFromListType(field);
            }
            if (selector == null) continue;
            this.addCachedHtmlField(field, selector, fieldClass);
        }
    }

    public T fromHtml(String htmlContent) {
        Document pageRoot = Jsoup.parse((String)htmlContent);
        return this.loadFromNode((Element)pageRoot);
    }

    private Selector getSelectorFromListType(Field field) {
        Type genericType = field.getGenericType();
        Class listClass = (Class)((ParameterizedType)genericType).getActualTypeArguments()[0];
        return listClass.getAnnotation(Selector.class);
    }

    private void addCachedHtmlField(Field field, Selector selector, Class<?> fieldClass) {
        HtmlField htmlField = List.class.isAssignableFrom(fieldClass) ? new HtmlListField(field, selector) : (Utils.isSimple(fieldClass) ? new HtmlSimpleField(field, selector) : new HtmlClassField(field, selector));
        this.htmlFieldCache.put(field.getName(), htmlField);
    }

    T loadFromNode(Element node) {
        T newInstance = this.createNewInstance();
        for (HtmlField<T> htmlField : this.htmlFieldCache.values()) {
            htmlField.setValue(this.jspoon, node, newInstance);
        }
        return newInstance;
    }

    private T createNewInstance() {
        T newInstance;
        Constructor<T> constructor;
        try {
            constructor = this.clazz.getDeclaredConstructor(new Class[0]);
        }
        catch (NoSuchMethodException e) {
            throw new ConstrucorNotFoundException(this.clazz.getSimpleName());
        }
        constructor.setAccessible(true);
        try {
            newInstance = constructor.newInstance(new Object[0]);
        }
        catch (Exception e) {
            throw new ObjectCreationException(this.clazz.getSimpleName());
        }
        return newInstance;
    }
}

