/*
 * Decompiled with CFR 0.152.
 */
package pl.droidsonroids.jspoon;

import java.lang.reflect.Field;
import java.text.DateFormat;
import java.text.NumberFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jsoup.nodes.Element;
import org.jsoup.select.Elements;
import pl.droidsonroids.jspoon.Jspoon;
import pl.droidsonroids.jspoon.annotation.Selector;
import pl.droidsonroids.jspoon.exception.DateParseException;
import pl.droidsonroids.jspoon.exception.DoubleParseException;
import pl.droidsonroids.jspoon.exception.FieldSetException;
import pl.droidsonroids.jspoon.exception.FloatParseException;

abstract class HtmlField<T> {
    Field field;
    private String cssQuery;
    private String attribute;
    private String format;
    private Locale locale;
    private String defValue;
    private int index;

    HtmlField(Field field, Selector selector) {
        this.field = field;
        this.cssQuery = selector.value();
        this.attribute = selector.attr();
        this.format = selector.format();
        this.setLocaleFromTag(selector.locale());
        this.defValue = selector.defValue();
        this.index = selector.index();
    }

    private void setLocaleFromTag(String localeTag) {
        this.locale = localeTag.equals("NO_VALUE") ? Locale.getDefault() : Locale.forLanguageTag(localeTag);
    }

    public abstract void setValue(Jspoon var1, Element var2, T var3);

    Element selectChild(Element parent) {
        return this.getElementAtIndexOrNull(parent);
    }

    Elements selectChildren(Element node) {
        return node.select(this.cssQuery);
    }

    private Element getElementAtIndexOrNull(Element parent) {
        Elements elements = this.selectChildren(parent);
        int size = elements.size();
        if (size == 0 || size <= this.index) {
            return null;
        }
        return (Element)elements.get(this.index);
    }

    static void setFieldOrThrow(Field field, Object newInstance, Object value) {
        try {
            field.setAccessible(true);
            field.set(newInstance, value);
        }
        catch (IllegalAccessException e) {
            throw new FieldSetException(newInstance.getClass().getSimpleName(), field.getName());
        }
    }

    <U> U instanceForNode(Element node, Class<U> clazz) {
        if (clazz.equals(Element.class)) {
            return (U)node;
        }
        String value = this.getValue(node, clazz);
        if (clazz.equals(String.class)) {
            return (U)value;
        }
        if (clazz.equals(Integer.class) || clazz.equals(Integer.TYPE)) {
            return (U)Integer.valueOf(value);
        }
        if (clazz.equals(Long.class) || clazz.equals(Long.TYPE)) {
            return (U)Long.valueOf(value);
        }
        if (clazz.equals(Boolean.class) || clazz.equals(Boolean.TYPE)) {
            return (U)Boolean.valueOf(value);
        }
        if (clazz.equals(Date.class)) {
            DateFormat dateFormat = this.getDateFormat();
            try {
                return (U)dateFormat.parse(value);
            }
            catch (ParseException e) {
                throw new DateParseException(value, this.format, this.locale);
            }
        }
        if (clazz.equals(Float.class) || clazz.equals(Float.TYPE)) {
            try {
                Number number = this.getNumberFromString(value);
                return (U)Float.valueOf(number.floatValue());
            }
            catch (ParseException e) {
                throw new FloatParseException(value, this.locale);
            }
        }
        if (clazz.equals(Double.class) || clazz.equals(Double.TYPE)) {
            try {
                Number number = this.getNumberFromString(value);
                return (U)Double.valueOf(number.floatValue());
            }
            catch (ParseException e) {
                throw new DoubleParseException(value, this.locale);
            }
        }
        return (U)value;
    }

    private <U> String getValue(Element node, Class<U> clazz) {
        Pattern pattern;
        Matcher matcher;
        boolean found;
        String value;
        if (node == null) {
            return this.defValue;
        }
        switch (this.attribute) {
            case "": {
                value = node.text();
                break;
            }
            case "html": 
            case "innerHtml": {
                value = node.html();
                break;
            }
            case "outerHtml": {
                value = node.outerHtml();
                break;
            }
            default: {
                value = node.attr(this.attribute);
            }
        }
        if (!clazz.equals(Date.class) && !this.format.equals("NO_VALUE") && (found = (matcher = (pattern = Pattern.compile(this.format)).matcher(value)).find()) && (value = matcher.group(1)).isEmpty()) {
            value = this.defValue;
        }
        return value;
    }

    private DateFormat getDateFormat() {
        if ("NO_VALUE".equals(this.format)) {
            return DateFormat.getDateInstance(2, this.locale);
        }
        return new SimpleDateFormat(this.format, this.locale);
    }

    private Number getNumberFromString(String value) throws ParseException {
        NumberFormat numberFormat = NumberFormat.getInstance(this.locale);
        return numberFormat.parse(value);
    }
}

