/*
 * Decompiled with CFR 0.152.
 */
package pl.droidsonroids.jspoon;

import java.lang.reflect.Field;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import org.jsoup.nodes.Element;
import org.jsoup.select.Elements;
import pl.droidsonroids.jspoon.HtmlAdapter;
import pl.droidsonroids.jspoon.HtmlField;
import pl.droidsonroids.jspoon.Jspoon;
import pl.droidsonroids.jspoon.Utils;
import pl.droidsonroids.jspoon.annotation.Selector;

class HtmlListField<T>
extends HtmlField<T> {
    HtmlListField(Field field, Selector selector) {
        super(field, selector);
    }

    @Override
    public void setValue(Jspoon jspoon, Element node, T newInstance) {
        Elements nodes = this.selectChildren(node);
        Type genericType = this.field.getGenericType();
        Type type = ((ParameterizedType)genericType).getActualTypeArguments()[0];
        Class listClass = (Class)type;
        HtmlListField.setFieldOrThrow(this.field, newInstance, this.populateList(jspoon, nodes, listClass));
    }

    private <V> List<V> populateList(Jspoon jspoon, Elements nodes, Class<V> listClazz) {
        ArrayList<V> newInstanceList = new ArrayList<V>();
        if (Utils.isSimple(listClazz)) {
            for (Element node : nodes) {
                newInstanceList.add(this.instanceForNode(node, listClazz));
            }
        } else {
            HtmlAdapter<V> htmlAdapter = jspoon.adapter(listClazz);
            for (Element node : nodes) {
                newInstanceList.add(htmlAdapter.loadFromNode(node));
            }
        }
        return newInstanceList;
    }
}

