import React from "/apps/websight-atlaskit-esm/web-resources/react.js";
import Spinner from "/apps/websight-atlaskit-esm/web-resources/@atlaskit/spinner.js";
export const LoadingWrapper = props => {
  const loadingWrapperStyle = {
    position: 'relative',
    pointerEvents: 'none',
    opacity: 0.6,
    filter: 'grayscale(50%)'
  };
  const loadingWrapperSpinnerStyle = {
    position: 'fixed',
    top: 0,
    bottom: 0,
    left: 0,
    right: 0,
    display: 'flex',
    justifyContent: 'center',
    alignItems: 'center',
    ...props.spinnerStyle
  };
  const spinner = /*#__PURE__*/React.createElement("span", {
    style: loadingWrapperSpinnerStyle
  }, /*#__PURE__*/React.createElement(Spinner, null));
  return /*#__PURE__*/React.createElement("div", {
    style: props.isLoading ? loadingWrapperStyle : null
  }, props.children, props.isLoading && spinner);
};