function _extends() { _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }

import React from "/apps/websight-atlaskit-esm/web-resources/react.js";
import { AsyncSelect, components } from "/apps/websight-atlaskit-esm/web-resources/@atlaskit/select.js";
import { layers } from "/apps/websight-atlaskit-esm/web-resources/@atlaskit/theme.js";
import RestClient from "/apps/websight-rest-esm-client/web-resources/RestClient.js";
import { debounce, getMaxHeightOfDropDown, getOptions } from "./services/AutosuggestionService.js";
/**
 * GenericAutosuggestion component allows to find a suggested options based on a query.
 *      It can be configureed to support selection of multiple options.
 *      Each option is a single object that can be choosen.
 */

export default class GenericAutosuggestion extends React.Component {
  /**
   * @param props = {
   *      placeholder: a short hint that describes the expected value of an input field,
   *      parameters: {
   *          autosuggestionType: e.g. authorizable etc.,
   *          ...otherParams
   *      },
   *      optionPostProcessor: post processor to format simple autosuggestion, e.g. add icons,
   *      optionsPostProcessor: post processor to format all autosuggestions
   *      defaultValue: define a default value of autosuggester
   *      formatOptionLabel: define a function that takes an option and returns it's appearance on list
   *      isMulti: define if input should be multiple choice,
   *      label: label to be displayed in the heading component,
   *      name: name of the HTML Input (optional - without this, no input will be rendered),
   *      noOptionsMessage: function that takes input value and returns message to show when there is no options,
   *      noOptionEmptyMessage: message to show when input is empty, e.g. Start typing to find
   *      onChange: function that is triggered on options change
   *      spacing: AsyncSelect appearance type
   *      value: define a value of autosuggester
   *      filterOut: define an array of filters
   * }
   */
  constructor(props) {
    super(props);
    this.state = {
      maxHeight: 500
    };
    this.restClient = new RestClient('websight-autosuggestion-service');
  }

  componentDidMount() {
    this.setState({
      maxHeight: getMaxHeightOfDropDown(this.inputRef)
    });
  }

  loadOptions(query, callback) {
    const {
      parameters,
      optionPostProcessor,
      optionsPostProcessor,
      filterOut
    } = this.props;
    const customPostProcessors = {
      optionPostProcessor,
      optionsPostProcessor
    };
    getOptions({ ...parameters,
      query
    }, customPostProcessors, options => {
      callback(options);
    }, filterOut);
  }

  render() {
    const {
      maxHeight
    } = this.state;
    return /*#__PURE__*/React.createElement(AsyncSelect, {
      components: {
        Input: props => {
          const innerRef = inputRef => {
            this.inputRef = inputRef;
            props.innerRef(inputRef);
          };

          return /*#__PURE__*/React.createElement(components.Input, _extends({}, props, {
            innerRef: innerRef
          }));
        }
      },
      defaultValue: this.props.defaultValue,
      formatOptionLabel: this.props.formatOptionLabel,
      isMulti: this.props.isMulti,
      isClearable: true,
      label: this.props.label,
      loadOptions: (...args) => this.debounceTimerId = debounce(() => this.loadOptions(...args), this.debounceTimerId),
      maxMenuHeight: maxHeight,
      menuPortalTarget: document.body,
      name: this.props.name,
      noOptionsMessage: ({
        inputValue
      }) => inputValue ? this.props.noOptionsMessage && this.props.noOptionsMessage(inputValue) : this.props.noOptionEmptyMessage,
      onChange: this.props.onChange,
      placeholder: this.props.placeholder,
      ref: element => this.select = element,
      spacing: this.props.spacing,
      styles: {
        menuPortal: base => ({ ...base,
          zIndex: layers.tooltip()
        })
      },
      value: this.props.value
    });
  }

}