function _extends() { _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }

import React from "/apps/websight-atlaskit-esm/web-resources/react.js";
import { optionData } from "../utils/AuthorizableAutosuggestionUtil.js";

const SelectTagIcon = props => {
  const iconStyle = {
    fontSize: '10px',
    verticalAlign: 'middle',
    paddingRight: '3px'
  };
  return /*#__PURE__*/React.createElement("i", _extends({
    className: "material-icons",
    style: iconStyle
  }, props), props.children);
};

const AUTHORIZABLE_TYPES = ['user', 'group', 'system_user'];
const typeToLabel = {
  user: 'Users',
  group: 'Groups',
  system_user: 'System Users'
};

const groupOptionsByType = options => {
  return AUTHORIZABLE_TYPES.map(type => ({
    label: typeToLabel[type] || type,
    options: options.filter(option => option.data.type === type)
  }));
};

class AuthorizableProcessorService {
  processMembersOptions(options) {
    return groupOptionsByType(options).map(type => ({ ...type,
      options: type.options.map(item => optionData(item))
    }));
  }

  processGroupOption(option) {
    return optionData(option);
  }

  formatOptionLabel(option) {
    return /*#__PURE__*/React.createElement(React.Fragment, null, /*#__PURE__*/React.createElement(SelectTagIcon, {
      className: "material-icons"
    }, option.icon), option.displayName);
  }

}

export default new AuthorizableProcessorService();