import React from "/apps/websight-atlaskit-esm/web-resources/react.js";
import styled from "/apps/websight-atlaskit-esm/web-resources/styled-components.js";
import { colors } from "/apps/websight-atlaskit-esm/web-resources/@atlaskit/theme.js";
export const ClearButton = props => {
  const Container = styled.button`
        border: none;
        display: flex;
        background-color: inherit;
        cursor: pointer;
        align-items: center;
        text-align: center;
        padding: 0px;
        border-radius: 50%;
    `;
  const Icon = styled.i`
        color: ${colors.N80};
        font-size: 16px;
        padding: 0 4px;

        &:hover {
            color: ${colors.N800};
        }
    `;
  return props.isVisible ? /*#__PURE__*/React.createElement(Container, {
    onClick: props.onClick
  }, /*#__PURE__*/React.createElement(Icon, {
    className: "material-icons"
  }, "cancel")) : /*#__PURE__*/React.createElement(React.Fragment, null);
};