/*
 * Decompiled with CFR 0.152.
 */
package pl.ds.websight.autosuggestion.dto;

import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import pl.ds.websight.autosuggestion.dto.SuggestionDto;

public class SuggestionListDto {
    private final boolean hasMoreResults;
    private final List<SuggestionDto> suggestions;

    private SuggestionListDto(List<SuggestionDto> suggestions, boolean hasMoreResults) {
        this.suggestions = suggestions;
        this.hasMoreResults = hasMoreResults;
    }

    public static SuggestionListDto buildEmpty() {
        return new SuggestionListDto(Collections.emptyList(), false);
    }

    public static SuggestionListDto buildFromValues(List<String> suggestions, boolean hasMoreResults) {
        return new SuggestionListDto(suggestions.stream().map(SuggestionDto::new).collect(Collectors.toList()), hasMoreResults);
    }

    public static SuggestionListDto buildFromSuggestions(List<SuggestionDto> suggestions, boolean hasMoreResults) {
        return new SuggestionListDto(suggestions, hasMoreResults);
    }

    public List<SuggestionDto> getSuggestions() {
        return this.suggestions;
    }

    public boolean getHasMoreResults() {
        return this.hasMoreResults;
    }
}

