/*
 * Decompiled with CFR 0.152.
 */
package pl.ds.websight.autosuggestion.service.impl;

import java.util.HashMap;
import java.util.Map;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pl.ds.websight.autosuggestion.service.AutosuggestionService;
import pl.ds.websight.autosuggestion.service.impl.AutosuggestionHandlerService;

@Component(immediate=true)
public class AutosuggestionHandlerServiceImpl
implements AutosuggestionHandlerService {
    private static final Logger LOG = LoggerFactory.getLogger(AutosuggestionHandlerServiceImpl.class);
    private final Map<String, AutosuggestionService> autosuggestions = new HashMap<String, AutosuggestionService>();

    @Reference(service=AutosuggestionService.class, cardinality=ReferenceCardinality.MULTIPLE, policy=ReferencePolicy.DYNAMIC)
    private synchronized void bindAutosuggestion(AutosuggestionService autosuggestion) {
        String autosuggestionType = autosuggestion.getType();
        LOG.info("Binding autosuggestion: {}", (Object)autosuggestionType);
        if (this.autosuggestions.containsKey(autosuggestionType)) {
            LOG.warn("Autosuggestion type '{}' is already registered", (Object)autosuggestionType);
        } else {
            this.autosuggestions.put(autosuggestionType, autosuggestion);
        }
    }

    private synchronized void unbindAutosuggestion(AutosuggestionService autosuggestion) {
        String autosuggestionType = autosuggestion.getType();
        LOG.info("Unbinding autosuggestion for type: {}", (Object)autosuggestionType);
        this.autosuggestions.remove(autosuggestionType);
    }

    @Override
    public synchronized AutosuggestionService getAutosuggestionByType(String autosuggestionType) {
        return this.autosuggestions.get(autosuggestionType);
    }
}

