/*
 * Decompiled with CFR 0.152.
 */
package pl.ds.websight.autosuggestion.service.impl.handlers.authorizable;

import java.util.ArrayList;
import java.util.List;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import org.apache.jackrabbit.api.security.user.Authorizable;
import org.apache.jackrabbit.api.security.user.Group;
import org.apache.jackrabbit.api.security.user.User;
import org.apache.jackrabbit.api.security.user.UserManager;
import org.apache.sling.api.request.RequestParameterMap;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.jcr.base.util.AccessControlUtil;
import pl.ds.websight.autosuggestion.dto.GroupDetailsDto;
import pl.ds.websight.autosuggestion.dto.SuggestionDto;
import pl.ds.websight.autosuggestion.dto.SuggestionListDto;
import pl.ds.websight.autosuggestion.dto.SystemUserDetailsDto;
import pl.ds.websight.autosuggestion.dto.UserDetailsDto;
import pl.ds.websight.autosuggestion.service.impl.handlers.AbstractAutosuggestionHandlerService;
import pl.ds.websight.autosuggestion.service.impl.handlers.authorizable.AuthorizablesFinder;

public abstract class AbstractAuthorizableAutosuggestionHandlerService
extends AbstractAutosuggestionHandlerService {
    static final String GROUP_PARAMETER = "group";

    @Override
    public SuggestionListDto getSuggestions(ResourceResolver resourceResolver, RequestParameterMap requestParameterMap) {
        try {
            AuthorizablesFinder authorizablesFinder = this.createAuthorizableFinder(resourceResolver, requestParameterMap);
            String authorizablePattern = this.getParamStringValue(requestParameterMap, "query");
            List<Authorizable> authorizables = authorizablesFinder.findAuthorizablesByPattern(authorizablePattern);
            ArrayList<SuggestionDto> suggestions = new ArrayList<SuggestionDto>(authorizables.size());
            for (Authorizable authorizable : authorizables) {
                if (authorizable.isGroup()) {
                    suggestions.add(new SuggestionDto(authorizable.getID(), new GroupDetailsDto((Group)authorizable)));
                    continue;
                }
                User user = (User)authorizable;
                if (user.isSystemUser()) {
                    suggestions.add(new SuggestionDto(user.getID(), new SystemUserDetailsDto(user)));
                    continue;
                }
                suggestions.add(new SuggestionDto(user.getID(), new UserDetailsDto(user)));
            }
            return SuggestionListDto.buildFromSuggestions(suggestions, false);
        }
        catch (RepositoryException e) {
            throw new IllegalStateException("Could not load authorizable autosuggestions", e);
        }
    }

    private AuthorizablesFinder createAuthorizableFinder(ResourceResolver resourceResolver, RequestParameterMap requestParameterMap) throws RepositoryException {
        UserManager userManager = AccessControlUtil.getUserManager((Session)((Session)resourceResolver.adaptTo(Session.class)));
        String group = this.getParamStringValue(requestParameterMap, GROUP_PARAMETER);
        return new AuthorizablesFinder(userManager, this.getResultClass(), group);
    }

    protected abstract Class<? extends Authorizable> getResultClass();
}

