/*
 * Decompiled with CFR 0.152.
 */
package pl.ds.websight.autosuggestion.service.impl.handlers.authorizable;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.stream.Stream;
import javax.jcr.RepositoryException;
import javax.validation.constraints.NotNull;
import org.apache.jackrabbit.api.security.user.Authorizable;
import org.apache.jackrabbit.api.security.user.Group;
import org.apache.jackrabbit.api.security.user.Query;
import org.apache.jackrabbit.api.security.user.QueryBuilder;
import org.apache.jackrabbit.api.security.user.User;
import org.apache.jackrabbit.api.security.user.UserManager;
import pl.ds.websight.autosuggestion.util.QueryUtil;

public class AuthorizablesFinder {
    private static final int RESULTS_LIMIT = 10;
    private static final int DEFAULT_OFFSET = 0;
    private final UserManager userManager;
    private final String groupName;
    private final Class<? extends Authorizable> type;
    private final boolean includeUsers;
    private final boolean includeGroups;

    protected AuthorizablesFinder(@NotNull UserManager userManager, @NotNull Class<? extends Authorizable> type, String groupName) {
        this.userManager = userManager;
        this.groupName = groupName;
        this.type = type;
        boolean assignableFromAuthorizable = type.isAssignableFrom(Authorizable.class);
        this.includeUsers = type.isAssignableFrom(User.class) || assignableFromAuthorizable;
        this.includeGroups = type.isAssignableFrom(Group.class) || assignableFromAuthorizable;
    }

    protected List<Authorizable> findAuthorizablesByPattern(final String pattern) throws RepositoryException {
        Iterator resourceIterator = this.userManager.findAuthorizables(new Query(){

            public <Q> void build(QueryBuilder<Q> builder) {
                builder.setSelector(AuthorizablesFinder.this.type);
                if (pattern != null && !pattern.isEmpty()) {
                    Stream.of(QueryUtil.caseInsensitiveLike(builder, "@rep:authorizableId", pattern), QueryUtil.caseInsensitiveLike(builder, "@rep:principalName", pattern), AuthorizablesFinder.this.includeGroups ? QueryUtil.caseInsensitiveLike(builder, "@displayName", pattern) : null, AuthorizablesFinder.this.includeUsers ? QueryUtil.caseInsensitiveLike(builder, "profile/@firstName", pattern) : null, AuthorizablesFinder.this.includeUsers ? QueryUtil.caseInsensitiveLike(builder, "profile/@lastName", pattern) : null).filter(Objects::nonNull).reduce((arg_0, arg_1) -> builder.or(arg_0, arg_1)).ifPresent(arg_0 -> builder.setCondition(arg_0));
                }
                if (AuthorizablesFinder.this.groupName != null) {
                    builder.setScope(AuthorizablesFinder.this.groupName, true);
                }
                builder.setLimit(0L, 10L);
            }
        });
        LinkedList<Authorizable> result = new LinkedList<Authorizable>();
        resourceIterator.forEachRemaining(result::add);
        return result;
    }
}

