/*
 * Decompiled with CFR 0.152.
 */
package pl.ds.websight.autosuggestion.service.impl.handlers.resource;

import org.apache.commons.lang3.StringUtils;
import org.apache.sling.api.request.RequestParameter;
import org.apache.sling.api.request.RequestParameterMap;
import pl.ds.websight.autosuggestion.util.PathUtil;

class PathAutosuggestionParams {
    private static final String QUERY_PARAMETER = "query";
    private static final String BASE_PATH_PARAMETER = "basePath";
    private static final String RETURN_RELATIVE_PATH_PARAMETER = "returnRelativePath";
    private static final String LIMIT_PARAMETER = "limit";
    private static final int MAX_RESULTS_SIZE = 100;
    private String basePath;
    private String query;
    private String name;
    private String parentPath;
    private String fullPath;
    private RequestParameterMap requestParameterMap;

    PathAutosuggestionParams(RequestParameterMap requestParameterMap) {
        this.requestParameterMap = requestParameterMap;
        this.fullPath = PathUtil.getFullPath(this.getBasePath(), this.getQuery());
    }

    String getParamStringValue(RequestParameterMap requestParameterMap, String paramName) {
        RequestParameter value = requestParameterMap.getValue(paramName);
        return value != null ? value.getString() : null;
    }

    String getBasePath() {
        if (this.basePath == null) {
            this.basePath = (String)StringUtils.defaultIfBlank((CharSequence)this.getParamStringValue(this.requestParameterMap, BASE_PATH_PARAMETER), (CharSequence)"/");
        }
        return this.basePath;
    }

    String getQuery() {
        if (this.query == null) {
            this.query = (String)StringUtils.defaultIfBlank((CharSequence)this.getParamStringValue(this.requestParameterMap, QUERY_PARAMETER), (CharSequence)"");
        }
        return this.query;
    }

    String getName() {
        if (this.name == null) {
            this.name = PathUtil.getName(this.fullPath);
        }
        return this.name;
    }

    String getParentPath() {
        if (this.parentPath == null) {
            this.parentPath = PathUtil.getParentPath(this.fullPath);
        }
        return this.parentPath;
    }

    boolean isRelativePath() {
        return Boolean.parseBoolean((String)StringUtils.defaultIfBlank((CharSequence)this.getParamStringValue(this.requestParameterMap, RETURN_RELATIVE_PATH_PARAMETER), (CharSequence)"false"));
    }

    int getLimit() {
        return Math.min(Integer.parseInt((String)StringUtils.defaultIfBlank((CharSequence)this.getParamStringValue(this.requestParameterMap, LIMIT_PARAMETER), (CharSequence)"10")), 100);
    }
}

