/*
 * Decompiled with CFR 0.152.
 */
package pl.ds.websight.autosuggestion.service.impl.handlers.resource;

import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.apache.sling.api.request.RequestParameterMap;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.osgi.service.component.annotations.Component;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pl.ds.websight.autosuggestion.dto.SuggestionDto;
import pl.ds.websight.autosuggestion.dto.SuggestionListDto;
import pl.ds.websight.autosuggestion.service.AutosuggestionService;
import pl.ds.websight.autosuggestion.service.impl.handlers.AbstractAutosuggestionHandlerService;
import pl.ds.websight.autosuggestion.service.impl.handlers.resource.PathAutosuggestionParams;
import pl.ds.websight.autosuggestion.util.PathUtil;

@Component(service={AutosuggestionService.class})
public class SlingPathAutosuggestionHandlerServiceImpl
extends AbstractAutosuggestionHandlerService {
    private static final Logger LOG = LoggerFactory.getLogger(SlingPathAutosuggestionHandlerServiceImpl.class);
    private static final String AUTOSUGGESTION_SERVICE_TYPE = "sling-path";
    private static final String RESPONSE_PARAMETER_HAS_CHILDREN = "hasChildren";

    @Override
    public String getType() {
        return AUTOSUGGESTION_SERVICE_TYPE;
    }

    @Override
    public SuggestionListDto getSuggestions(ResourceResolver resourceResolver, RequestParameterMap requestParameterMap) {
        PathAutosuggestionParams pathAutosuggestionParams = new PathAutosuggestionParams(requestParameterMap);
        String basePath = pathAutosuggestionParams.getBasePath();
        if (!basePath.startsWith("/")) {
            LOG.warn("Parameter 'basePath' is not absolute path '{}'", (Object)basePath);
            return SuggestionListDto.buildEmpty();
        }
        LinkedList<SuggestionDto> results = new LinkedList<SuggestionDto>();
        int limit = pathAutosuggestionParams.getLimit();
        results.addAll(this.getSuggestionsForSearchPath(pathAutosuggestionParams.getParentPath(), pathAutosuggestionParams.getName(), resourceResolver, pathAutosuggestionParams.isRelativePath(), limit + 1));
        return SuggestionListDto.buildFromSuggestions(results.subList(0, results.size()), results.size() > limit);
    }

    private List<SuggestionDto> getSuggestionsForSearchPath(String parentPath, String name, ResourceResolver resourceResolver, boolean isRelativePath, int limit) {
        Resource parentResource = resourceResolver.getResource(parentPath);
        if (parentResource == null) {
            LOG.warn("Could not find parent resource '{}'", (Object)parentPath);
            return Collections.emptyList();
        }
        return this.getChildrenSuggestionsByQuery(parentPath, name, parentResource, isRelativePath, limit);
    }

    private List<SuggestionDto> getChildrenSuggestionsByQuery(String parentPath, String name, Resource parentResource, boolean isRelativePath, int limit) {
        return StreamSupport.stream(parentResource.getChildren().spliterator(), false).filter(resource -> resource.getName().startsWith(name)).sorted(Comparator.comparing(Resource::getPath)).limit(limit).map(resource -> SlingPathAutosuggestionHandlerServiceImpl.createSuggestion(isRelativePath ? PathUtil.getRelativePath(parentPath, resource.getPath()) : resource.getPath(), resource.hasChildren())).collect(Collectors.toList());
    }

    private static SuggestionDto createSuggestion(String path, boolean hasChildren) {
        Map<String, Boolean> data = Collections.singletonMap(RESPONSE_PARAMETER_HAS_CHILDREN, hasChildren);
        return new SuggestionDto(path, data);
    }
}

