/*
 * Decompiled with CFR 0.152.
 */
package pl.ds.websight.fragments.registry.impl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.sling.api.SlingHttpServletRequest;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pl.ds.websight.fragments.registry.ConditionalWebFragment;
import pl.ds.websight.fragments.registry.WebFragment;
import pl.ds.websight.fragments.registry.WebFragmentRegistry;

@Component(immediate=true)
public class WebFragmentRegistryImpl
implements WebFragmentRegistry {
    private static final Logger LOG = LoggerFactory.getLogger(WebFragmentRegistryImpl.class);
    private Map<String, List<WebFragment>> webFragmentsByKey = new HashMap<String, List<WebFragment>>();

    @Reference(service=WebFragment.class, cardinality=ReferenceCardinality.MULTIPLE, policy=ReferencePolicy.DYNAMIC)
    private synchronized void bindWebFragment(WebFragment webFragment) {
        this.log("Binding Web Fragment", webFragment);
        List webFragments = this.webFragmentsByKey.computeIfAbsent(webFragment.getKey(), k -> new ArrayList());
        webFragments.add(webFragment);
        webFragments.sort(Comparator.comparingInt(WebFragment::getRanking));
    }

    private synchronized void unbindWebFragment(WebFragment webFragment) {
        this.log("Unbinding Web Fragment", webFragment);
        this.webFragmentsByKey.get(webFragment.getKey()).remove(webFragment);
    }

    @Override
    public synchronized List<String> getFragments(String key, SlingHttpServletRequest request) {
        return this.webFragmentsByKey.getOrDefault(key, Collections.emptyList()).stream().filter(webFragment -> this.isApplicable((WebFragment)webFragment, request)).map(WebFragment::getFragment).collect(Collectors.toList());
    }

    private boolean isApplicable(WebFragment webFragment, SlingHttpServletRequest request) {
        if (webFragment instanceof ConditionalWebFragment) {
            return ((ConditionalWebFragment)webFragment).isApplicable(request);
        }
        return true;
    }

    private void log(String message, WebFragment webFragment) {
        String logFormat = message + " type = {}, key = {}, fragment = {}, ranking = {}";
        LOG.info(logFormat, new Object[]{webFragment.getClass().getName(), webFragment.getKey(), webFragment.getFragment(), webFragment.getRanking()});
    }
}

