/*
 * Decompiled with CFR 0.152.
 */
package pl.ds.websight.packagemanager;

import javax.jcr.RepositoryException;
import javax.jcr.Session;
import org.apache.jackrabbit.vault.packaging.JcrPackageManager;
import org.apache.jackrabbit.vault.packaging.Packaging;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ResourceResolverFactory;
import org.apache.sling.event.jobs.Job;
import org.apache.sling.event.jobs.consumer.JobConsumer;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pl.ds.websight.packagemanager.JobProperties;
import pl.ds.websight.packagemanager.rest.DeletePackageRestAction;
import pl.ds.websight.packagemanager.util.JobUtil;
import pl.ds.websight.packagemanager.util.OpenPackageException;

@Component(service={JobConsumer.class}, property={"job.topics=pl/ds/websight/packagemanager/packageaction/delete"})
public class DeletePackageScheduleJobConsumer
implements JobConsumer {
    private static final Logger LOG = LoggerFactory.getLogger(DeletePackageScheduleJobConsumer.class);
    public static final String TOPIC = "pl/ds/websight/packagemanager/packageaction/delete";
    @Reference
    private ResourceResolverFactory resolverFactory;
    @Reference
    private Packaging packaging;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public JobConsumer.JobResult process(Job job) {
        JobProperties jobProperties = JobProperties.fetch(job);
        if (jobProperties == null) {
            LOG.warn("Invalid properties structure for {}", (Object)job.getTopic());
            return JobConsumer.JobResult.CANCEL;
        }
        String packageReference = jobProperties.getPackageReference();
        String applicantId = jobProperties.getApplicantId();
        LOG.debug("Acquired job properties for package deletion on path: {}, requested by user: {}, starting processing package operations", (Object)packageReference, (Object)applicantId);
        try (ResourceResolver applicantResolver = JobUtil.getImpersonatedResolver(this.resolverFactory, applicantId);){
            if (applicantResolver == null) {
                LOG.warn("Failed to use impersonated resource resolver for applicant: {}", (Object)applicantId);
                JobConsumer.JobResult jobResult = JobConsumer.JobResult.FAILED;
                return jobResult;
            }
            Session applicantSession = (Session)applicantResolver.adaptTo(Session.class);
            if (applicantSession == null) {
                LOG.warn("Could not access session for applicant: {}", (Object)applicantId);
                JobConsumer.JobResult jobResult = JobConsumer.JobResult.FAILED;
                return jobResult;
            }
            if (!applicantSession.nodeExists(packageReference)) {
                LOG.warn("Package: {} was not found, so it cannot be deleted", (Object)packageReference);
                JobConsumer.JobResult jobResult = JobConsumer.JobResult.FAILED;
                return jobResult;
            }
            JcrPackageManager packageManager = this.packaging.getPackageManager(applicantSession);
            DeletePackageRestAction.processDelete(packageReference, applicantSession, packageManager);
            return JobConsumer.JobResult.OK;
        }
        catch (RepositoryException | OpenPackageException e) {
            LOG.warn("Could not perform scheduled delete for package: {}, requested by user: {}", new Object[]{packageReference, applicantId, e});
            return JobConsumer.JobResult.FAILED;
        }
    }
}

