/*
 * Decompiled with CFR 0.152.
 */
package pl.ds.websight.packagemanager;

import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.sling.event.jobs.Job;
import org.apache.sling.event.jobs.ScheduledJobInfo;

public class JobProperties {
    private static final String APPLICANT_ID_PROPS_PARAM = "userId";
    private static final String PACKAGE_REF_PROPS_PARAM = "reference";
    private final String packageReference;
    private final String applicantId;

    private JobProperties(String packageReference, String applicantId) {
        this.packageReference = packageReference;
        this.applicantId = applicantId;
    }

    public String getPackageReference() {
        return this.packageReference;
    }

    public String getApplicantId() {
        return this.applicantId;
    }

    public static JobProperties fetch(Job job) {
        String packageReference = (String)job.getProperty(PACKAGE_REF_PROPS_PARAM, String.class);
        String applicantId = (String)job.getProperty(APPLICANT_ID_PROPS_PARAM, String.class);
        return StringUtils.isNotBlank((CharSequence)packageReference) && StringUtils.isNotBlank((CharSequence)applicantId) ? new JobProperties(packageReference, applicantId) : null;
    }

    public static JobProperties fetch(ScheduledJobInfo scheduledInfo) {
        Map jobProperties = scheduledInfo.getJobProperties();
        String packageReference = jobProperties.containsKey(PACKAGE_REF_PROPS_PARAM) ? jobProperties.get(PACKAGE_REF_PROPS_PARAM).toString() : null;
        String applicantId = jobProperties.containsKey(APPLICANT_ID_PROPS_PARAM) ? jobProperties.get(APPLICANT_ID_PROPS_PARAM).toString() : null;
        return StringUtils.isNotBlank((CharSequence)packageReference) && StringUtils.isNotBlank((CharSequence)applicantId) ? new JobProperties(packageReference, applicantId) : null;
    }

    public static Map<String, Object> toMap(String packagePath, String userID) {
        HashMap<String, Object> jobProperties = new HashMap<String, Object>();
        jobProperties.put(PACKAGE_REF_PROPS_PARAM, packagePath);
        jobProperties.put(APPLICANT_ID_PROPS_PARAM, userID);
        return jobProperties;
    }

    public static Map<String, Object> asQueryMap(String packagePath) {
        HashMap<String, Object> jobQueryProperties = new HashMap<String, Object>();
        jobQueryProperties.put(PACKAGE_REF_PROPS_PARAM, packagePath);
        return jobQueryProperties;
    }

    public static String getApplicantId(Job job) {
        return (String)job.getProperty(APPLICANT_ID_PROPS_PARAM, String.class);
    }

    public static String getApplicantId(ScheduledJobInfo scheduledJobInfo) {
        return JobProperties.getStringProp(scheduledJobInfo, APPLICANT_ID_PROPS_PARAM);
    }

    public static String getPackagePath(Job job) {
        return (String)job.getProperty(PACKAGE_REF_PROPS_PARAM, String.class);
    }

    public static String getPackagePath(ScheduledJobInfo scheduledJobInfo) {
        return JobProperties.getStringProp(scheduledJobInfo, PACKAGE_REF_PROPS_PARAM);
    }

    private static String getStringProp(ScheduledJobInfo scheduledJobInfo, String propName) {
        Map jobProperties = scheduledJobInfo.getJobProperties();
        return jobProperties.containsKey(propName) ? jobProperties.get(propName).toString() : null;
    }
}

