/*
 * Decompiled with CFR 0.152.
 */
package pl.ds.websight.packagemanager.dto;

import org.apache.jackrabbit.vault.packaging.JcrPackage;
import pl.ds.websight.packagemanager.dto.PackageActionInfoDto;
import pl.ds.websight.packagemanager.util.JcrPackageStatusUtil;
import pl.ds.websight.packagemanager.util.JcrPackageUtil;

public final class PackageStatusDto {
    private final PackageActionInfoDto build;
    private final PackageActionInfoDto installation;
    private final PackageActionInfoDto modification;

    private PackageStatusDto(JcrPackage jcrPackage) {
        boolean hasValidBuildDate = JcrPackageUtil.fetchDefinition(jcrPackage).map(packageDefinition -> packageDefinition.getCreated() != null).orElse(false);
        this.build = hasValidBuildDate ? PackageStatusDto.getActionStatus(jcrPackage, "jcr:created") : PackageActionInfoDto.createUploadPackageInfo(jcrPackage.getNode());
        this.installation = JcrPackageStatusUtil.isInstalled(jcrPackage) ? PackageStatusDto.getActionStatus(jcrPackage, "lastUnpacked") : null;
        this.modification = JcrPackageStatusUtil.isModified(jcrPackage) ? PackageStatusDto.getActionStatus(jcrPackage, "jcr:lastModified") : null;
    }

    private static PackageActionInfoDto getActionStatus(JcrPackage jcrPackage, String actionPropName) {
        return JcrPackageUtil.fetchDefinition(jcrPackage).map(jcrPackageDefinition -> PackageActionInfoDto.create(jcrPackageDefinition, actionPropName)).orElse(null);
    }

    public PackageActionInfoDto getBuild() {
        return this.build;
    }

    public PackageActionInfoDto getInstallation() {
        return this.installation;
    }

    public PackageActionInfoDto getModification() {
        return this.modification;
    }

    public static PackageStatusDto fetchPackageStatus(JcrPackage jcrPackage) {
        return JcrPackageStatusUtil.isBuilt(jcrPackage) ? new PackageStatusDto(jcrPackage) : null;
    }
}

