/*
 * Decompiled with CFR 0.152.
 */
package pl.ds.websight.packagemanager.packageaction;

import java.util.Calendar;
import java.util.Locale;
import java.util.TimeZone;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.apache.commons.lang3.time.DateFormatUtils;
import org.apache.jackrabbit.vault.fs.api.ProgressTrackerListener;
import org.apache.jackrabbit.vault.packaging.JcrPackage;
import org.apache.jackrabbit.vault.packaging.JcrPackageManager;
import org.apache.jackrabbit.vault.packaging.Packaging;
import org.apache.sling.api.resource.ModifiableValueMap;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ResourceResolverFactory;
import org.apache.sling.commons.classloader.DynamicClassLoaderManager;
import org.apache.sling.event.jobs.Job;
import org.apache.sling.event.jobs.consumer.JobConsumer;
import org.apache.sling.jcr.api.SlingRepository;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pl.ds.websight.packagemanager.packageaction.PackageActionJobFinishedHandler;
import pl.ds.websight.packagemanager.packageaction.PackageActionJobProperties;
import pl.ds.websight.packagemanager.packageaction.PackageActionLogProgressListener;
import pl.ds.websight.packagemanager.packageoptions.PackageImportOptions;
import pl.ds.websight.packagemanager.rest.requestparameters.PackageActionCommand;
import pl.ds.websight.packagemanager.util.JcrPackageUtil;
import pl.ds.websight.packagemanager.util.JobUtil;
import pl.ds.websight.packagemanager.util.PackageLogUtil;

@Component(service={JobConsumer.class}, property={"job.topics=pl/ds/websight/packagemanager/packageaction/install", "job.topics=pl/ds/websight/packagemanager/packageaction/uninstall", "job.topics=pl/ds/websight/packagemanager/packageaction/build", "job.topics=pl/ds/websight/packagemanager/packageaction/coverage"})
public class PackageActionJobConsumer
implements JobConsumer {
    private static final Logger LOG = LoggerFactory.getLogger(PackageActionJobConsumer.class);
    public static final String INSTALL_TOPIC = "pl/ds/websight/packagemanager/packageaction/install";
    public static final String UNINSTALL_TOPIC = "pl/ds/websight/packagemanager/packageaction/uninstall";
    public static final String BUILD_TOPIC = "pl/ds/websight/packagemanager/packageaction/build";
    public static final String COVERAGE_TOPIC = "pl/ds/websight/packagemanager/packageaction/coverage";
    private static final String START_DATE_PATTERN = "EEE MMM dd HH:mm:ss 'GMT'Z '('zzzz')'";
    @Reference
    private ResourceResolverFactory resolverFactory;
    @Reference
    private SlingRepository repository;
    @Reference
    private Packaging packaging;
    @Reference
    private DynamicClassLoaderManager classLoaderManager;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public JobConsumer.JobResult process(Job job) {
        PackageActionJobProperties properties = PackageActionJobProperties.fetch(job);
        if (properties == null) {
            LOG.warn("Invalid properties structure for {}", (Object)job.getTopic());
            return JobConsumer.JobResult.CANCEL;
        }
        PackageActionCommand command = PackageActionCommand.fetchByJobTopic(job.getTopic());
        String applicantId = properties.getApplicantId();
        String packageReference = properties.getPackageReference();
        LOG.debug("Acquired action job properties for package: {} and user: {}, starting processing action pre operations", (Object)packageReference, (Object)applicantId);
        PackageActionJobFinishedHandler actionFinishedHandler = new PackageActionJobFinishedHandler(this.resolverFactory, properties, job.getId(), command);
        try (ResourceResolver applicantResolver = JobUtil.getImpersonatedResolver(this.resolverFactory, applicantId);){
            if (applicantResolver == null) {
                LOG.warn("Failed to use impersonated resource resolver for applicant: {}", (Object)applicantId);
                PackageActionJobConsumer.handleFailedFinish(actionFinishedHandler, command, "Failed to get " + applicantId + " resource resolver");
                JobConsumer.JobResult jobResult = JobConsumer.JobResult.FAILED;
                return jobResult;
            }
            Session applicantSession = (Session)applicantResolver.adaptTo(Session.class);
            if (applicantSession == null) {
                PackageActionJobConsumer.handleFailedFinish(actionFinishedHandler, command, "Could not access session for applicant: " + applicantId);
                JobConsumer.JobResult jobResult = JobConsumer.JobResult.FAILED;
                return jobResult;
            }
            if (!applicantSession.nodeExists(packageReference)) {
                PackageActionJobConsumer.handleFailedFinish(actionFinishedHandler, command, "Package: " + packageReference + " was not found");
                JobConsumer.JobResult jobResult = JobConsumer.JobResult.FAILED;
                return jobResult;
            }
            String logNodePath = properties.getLogPath();
            PackageActionJobConsumer.deleteLog(applicantSession, logNodePath);
            applicantSession.save();
            LOG.debug("Removed successfully log for package: {}", (Object)logNodePath);
            ModifiableValueMap logValueMap = PackageLogUtil.getOrCreatePackageLogMap(applicantResolver, logNodePath);
            if (logValueMap == null) {
                PackageActionJobConsumer.handleFailedFinish(actionFinishedHandler, command, "Could not adapt action log under " + logNodePath + " to " + ModifiableValueMap.class.getSimpleName());
                JobConsumer.JobResult jobResult = JobConsumer.JobResult.FAILED;
                return jobResult;
            }
            PackageLogUtil.updateActionInfo(command.toString(), applicantId, logValueMap);
            LOG.debug("Processed all action pre operations for package: {}, starting action: {}", (Object)packageReference, (Object)command);
            PackageActionLogProgressListener progressListener = new PackageActionLogProgressListener(logValueMap, applicantResolver, this.resolverFactory.getSearchPath(), job.getId());
            JobConsumer.JobResult jobResult = this.processPackageAction(actionFinishedHandler, properties, job.getProcessingStarted(), progressListener, applicantSession, command);
            return jobResult;
        }
        catch (Exception e) {
            LOG.warn("Could not perform action: {} on package: {}", new Object[]{command, packageReference, e});
            PackageActionJobConsumer.handleFailedFinish(actionFinishedHandler, command, e);
            return JobConsumer.JobResult.FAILED;
        }
    }

    private static void handleFailedFinish(PackageActionJobFinishedHandler handler, PackageActionCommand command, String exceptionMsg) {
        handler.handleFinish(String.format("Package %s failed.", command.toString()), exceptionMsg);
    }

    private static void deleteLog(Session applicantSession, String logNodePath) throws RepositoryException {
        if (applicantSession.nodeExists(logNodePath)) {
            applicantSession.removeItem(logNodePath);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private JobConsumer.JobResult processPackageAction(PackageActionJobFinishedHandler handler, PackageActionJobProperties properties, Calendar jobStart, PackageActionLogProgressListener listener, Session applicantSession, PackageActionCommand commandToExecute) {
        JobConsumer.JobResult jobResult;
        JcrPackage packageToProcess;
        boolean isActionExecutionSuccessful;
        String packageReference;
        block13: {
            block12: {
                packageReference = properties.getPackageReference();
                isActionExecutionSuccessful = false;
                PackageImportOptions packageImportOptions = properties.getPackageImportOptions();
                JcrPackageManager packageManager = this.packaging.getPackageManager(applicantSession);
                packageToProcess = JcrPackageUtil.open(packageReference, applicantSession, packageManager);
                PackageActionJobConsumer.appendPackageActionHeader(listener, packageReference, packageImportOptions.isDryRun(), jobStart, commandToExecute.getLogPrefix(), commandToExecute.getDescription());
                commandToExecute.executeCommand(packageToProcess, packageImportOptions, listener, this.classLoaderManager.getDynamicClassLoader(), packageManager);
                isActionExecutionSuccessful = true;
                LOG.debug("{} of package {} finished successfully", (Object)commandToExecute, (Object)packageReference);
                jobResult = JobConsumer.JobResult.OK;
                if (packageToProcess == null) break block12;
                packageToProcess.close();
            }
            if (!isActionExecutionSuccessful) break block13;
            listener.flushUnsavedData();
            handler.handleFinish(String.format("%s in %dms.", commandToExecute.getLogSuffix(), Math.abs(System.currentTimeMillis() - jobStart.getTimeInMillis())));
        }
        return jobResult;
        {
            catch (Throwable throwable) {
                try {
                    try {
                        if (packageToProcess != null) {
                            try {
                                packageToProcess.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (Exception e) {
                        listener.flushUnsavedData();
                        LOG.warn("Could not perform action: {} on package: {}", new Object[]{commandToExecute, packageReference, e});
                        PackageActionJobConsumer.handleFailedFinish(handler, commandToExecute, e);
                        JobConsumer.JobResult jobResult2 = JobConsumer.JobResult.FAILED;
                        if (isActionExecutionSuccessful) {
                            listener.flushUnsavedData();
                            handler.handleFinish(String.format("%s in %dms.", commandToExecute.getLogSuffix(), Math.abs(System.currentTimeMillis() - jobStart.getTimeInMillis())));
                        }
                        return jobResult2;
                    }
                }
                catch (Throwable throwable3) {
                    if (isActionExecutionSuccessful) {
                        listener.flushUnsavedData();
                        handler.handleFinish(String.format("%s in %dms.", commandToExecute.getLogSuffix(), Math.abs(System.currentTimeMillis() - jobStart.getTimeInMillis())));
                    }
                    throw throwable3;
                }
            }
        }
    }

    private static void appendPackageActionHeader(ProgressTrackerListener listener, String packageReference, boolean dryRun, Calendar jobStart, String commandPrefix, String commandDescription) {
        String commandLogPrefix = (dryRun ? "Test " : "") + commandPrefix;
        listener.onMessage(ProgressTrackerListener.Mode.TEXT, commandLogPrefix, packageReference);
        listener.onMessage(ProgressTrackerListener.Mode.TEXT, DateFormatUtils.format((Calendar)jobStart, (String)START_DATE_PATTERN, (TimeZone)jobStart.getTimeZone(), (Locale)JcrPackageUtil.DEFAULT_LOCALE), null);
        listener.onMessage(ProgressTrackerListener.Mode.TEXT, "", null);
        listener.onMessage(ProgressTrackerListener.Mode.TEXT, commandDescription + (dryRun ? " (dry run)" : ""), null);
    }

    private static void handleFailedFinish(PackageActionJobFinishedHandler handler, PackageActionCommand command, Exception e) {
        handler.handleFinish(String.format("Package %s failed.", command.toString()), ExceptionUtils.getStackTrace((Throwable)e));
    }
}

