/*
 * Decompiled with CFR 0.152.
 */
package pl.ds.websight.packagemanager.packageaction;

import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.sling.api.resource.ModifiableValueMap;
import org.apache.sling.api.resource.PersistenceException;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ResourceResolverFactory;
import org.apache.sling.api.resource.ValueMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pl.ds.websight.packagemanager.packageaction.PackageActionJobProperties;
import pl.ds.websight.packagemanager.rest.requestparameters.PackageActionCommand;
import pl.ds.websight.packagemanager.util.JobUtil;
import pl.ds.websight.packagemanager.util.PackageLogUtil;

public final class PackageActionJobFinishedHandler {
    private static final Logger LOG = LoggerFactory.getLogger(PackageActionJobFinishedHandler.class);
    private final ResourceResolverFactory resolverFactory;
    private final PackageActionJobProperties properties;
    private final String jobId;
    private final String actionType;

    public PackageActionJobFinishedHandler(ResourceResolverFactory resolverFactory, PackageActionJobProperties properties, String jobId, PackageActionCommand packageActionCommand) {
        this.resolverFactory = resolverFactory;
        this.properties = properties;
        this.jobId = jobId;
        this.actionType = packageActionCommand.toString();
    }

    public void handleFinish(String finishMessage) {
        this.handleFinish(finishMessage, null);
    }

    public void handleFinish(String finishMessage, String exceptionStacktrace) {
        String applicantId = this.properties.getApplicantId();
        try (ResourceResolver applicantResolver = JobUtil.getImpersonatedResolver(this.resolverFactory, applicantId);){
            ModifiableValueMap logValueMap = Optional.ofNullable(applicantResolver).map(resolver -> PackageLogUtil.getOrCreatePackageLogMap(resolver, this.properties.getLogPath())).orElse(null);
            if (logValueMap == null) {
                LOG.warn("Could not access basic action log objects for user {} and path {}", (Object)applicantId, (Object)this.properties.getPackageReference());
                return;
            }
            PackageLogUtil.updateActionInfo(this.actionType, applicantId, logValueMap);
            List<String> footerEntries = PackageActionJobFinishedHandler.getFooterEntries(finishMessage, exceptionStacktrace);
            if (exceptionStacktrace != null && PackageLogUtil.isLogsAuthorDifferent(this.jobId, (ValueMap)logValueMap)) {
                PackageActionJobFinishedHandler.removeAllLogs((ValueMap)logValueMap);
                logValueMap.put((Object)"logAuthorId", (Object)this.jobId);
                PackageActionJobFinishedHandler.saveCompletedLogs(logValueMap, "entries0-1000", footerEntries);
            } else {
                PackageActionJobFinishedHandler.appendPackageLogFooter(logValueMap, footerEntries);
            }
            applicantResolver.commit();
        }
        catch (PersistenceException e) {
            LOG.warn("Could not insert finish info", (Throwable)e);
        }
    }

    private static List<String> getFooterEntries(String finishMessage, String stacktrace) {
        LinkedList<String> entries = new LinkedList<String>();
        List<String> stacktraceList = PackageLogUtil.splitLogEntry(stacktrace);
        if (stacktraceList != null) {
            entries.addAll(stacktraceList);
        }
        entries.add("");
        entries.add(finishMessage);
        return entries;
    }

    private static void removeAllLogs(ValueMap valueMap) {
        valueMap.keySet().stream().filter(PackageLogUtil::isLogEntry).collect(Collectors.toList()).forEach(arg_0 -> valueMap.remove(arg_0));
    }

    private static void appendPackageLogFooter(ModifiableValueMap logValueMap, List<String> footerEntries) {
        String lastLogEntryName = PackageActionJobFinishedHandler.getLastLogEntryName((ValueMap)logValueMap);
        if (lastLogEntryName == null) {
            LOG.warn("No log has been specified, skipped finish info addition");
            return;
        }
        List<String> lastLogEntries = PackageLogUtil.getLogEntry((ValueMap)logValueMap, lastLogEntryName);
        if (lastLogEntries != null) {
            lastLogEntries.addAll(footerEntries);
            PackageActionJobFinishedHandler.saveCompletedLogs(logValueMap, lastLogEntryName, lastLogEntries);
        }
    }

    private static String getLastLogEntryName(ValueMap valueMap) {
        return valueMap.keySet().stream().filter(PackageLogUtil::isLogEntry).max(Comparator.comparing(logProp -> {
            String range = logProp.substring("entries".length());
            return (Long)PackageLogUtil.getRangeLimits(range).getLeft();
        })).orElse(null);
    }

    private static void saveCompletedLogs(ModifiableValueMap logValueMap, String lastLogEntryName, List<String> updatedLogs) {
        String range = PackageLogUtil.removeLogEntryNamePrefix(lastLogEntryName);
        while (updatedLogs.size() >= 1000) {
            List<String> fullEntry = updatedLogs.subList(0, 1000);
            PackageLogUtil.putLog(logValueMap, range, fullEntry);
            range = PackageLogUtil.increaseRange(range);
            updatedLogs.removeAll(fullEntry);
        }
        PackageLogUtil.putLog(logValueMap, range, updatedLogs);
        PackageActionJobFinishedHandler.deleteLastCarriageReturn(logValueMap, range);
    }

    private static void deleteLastCarriageReturn(ModifiableValueMap logValueMap, String range) {
        String lastLineWithoutCarriageReturn = StringUtils.removeEnd((String)((String)logValueMap.get("entries" + range, String.class)), (String)"\n");
        logValueMap.put((Object)("entries" + range), (Object)lastLineWithoutCarriageReturn);
    }
}

