/*
 * Decompiled with CFR 0.152.
 */
package pl.ds.websight.packagemanager.rest;

import javax.jcr.RepositoryException;
import javax.jcr.Session;
import org.apache.jackrabbit.vault.packaging.JcrPackage;
import org.apache.jackrabbit.vault.packaging.JcrPackageManager;
import org.apache.jackrabbit.vault.packaging.Packaging;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pl.ds.websight.packagemanager.rest.AbstractRestAction;
import pl.ds.websight.packagemanager.rest.DeletePackageRestModel;
import pl.ds.websight.packagemanager.rest.Messages;
import pl.ds.websight.packagemanager.util.JcrPackageUtil;
import pl.ds.websight.packagemanager.util.OpenPackageException;
import pl.ds.websight.packagemanager.util.PackageLogUtil;
import pl.ds.websight.rest.framework.RestAction;
import pl.ds.websight.rest.framework.RestActionResult;
import pl.ds.websight.rest.framework.annotations.SlingAction;

@SlingAction
@Component
public class DeletePackageRestAction
extends AbstractRestAction<DeletePackageRestModel, Void>
implements RestAction<DeletePackageRestModel, Void> {
    private static final Logger LOG = LoggerFactory.getLogger(DeletePackageRestAction.class);
    @Reference
    private Packaging packaging;

    @Override
    protected RestActionResult<Void> performAction(DeletePackageRestModel model) throws RepositoryException {
        Session session = model.getSession();
        String packagePath = model.getPath();
        try {
            DeletePackageRestAction.processDelete(packagePath, session, this.packaging.getPackageManager(session));
            return RestActionResult.success((String)"Package deleted", (String)Messages.formatMessage("Package '%s' has been deleted", packagePath));
        }
        catch (OpenPackageException e) {
            LOG.warn("Could not open package: {}", (Object)packagePath, (Object)e);
            return RestActionResult.failure((String)e.getSimplifiedMessage(), (String)e.getMessage());
        }
    }

    public static void processDelete(String packagePath, Session session, JcrPackageManager packageManager) throws RepositoryException, OpenPackageException {
        try (JcrPackage packageToDelete = JcrPackageUtil.open(packagePath, session, packageManager);){
            packageManager.remove(packageToDelete);
            LOG.info("Successfully deleted package: {}", (Object)packagePath);
            DeletePackageRestAction.deletePackageLogs(session, packagePath);
        }
    }

    private static void deletePackageLogs(Session session, String packagePath) throws RepositoryException {
        String logPath = PackageLogUtil.getLogPath(packagePath);
        if (!session.nodeExists(logPath)) {
            return;
        }
        session.removeItem(logPath);
        session.save();
    }

    @Override
    protected String getUnexpectedErrorMessage() {
        return "Could not delete package";
    }
}

