/*
 * Decompiled with CFR 0.152.
 */
package pl.ds.websight.packagemanager.rest;

import java.util.Collections;
import java.util.List;
import javax.annotation.PostConstruct;
import javax.jcr.Session;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.models.annotations.Default;
import org.apache.sling.models.annotations.Model;
import org.apache.sling.models.annotations.injectorspecific.Self;
import pl.ds.websight.packagemanager.rest.requestparameters.FilterOption;
import pl.ds.websight.packagemanager.rest.requestparameters.SortBy;
import pl.ds.websight.request.parameters.support.annotations.RequestParameter;

@Model(adaptables={SlingHttpServletRequest.class})
public class FindPackagesRestModel {
    @RequestParameter
    private SortBy sortBy;
    @RequestParameter
    private List<FilterOption> filterOptions;
    @RequestParameter(name="filter")
    private String packageNameFilter;
    @RequestParameter
    private String group;
    @RequestParameter
    private String path;
    @RequestParameter
    @Default(longValues={1L})
    private Long pageNumber;
    @Self
    private SlingHttpServletRequest request;
    private Session session;

    @PostConstruct
    protected void init() {
        this.session = (Session)this.request.getResourceResolver().adaptTo(Session.class);
        this.sortBy = (SortBy)((Object)ObjectUtils.defaultIfNull((Object)((Object)this.sortBy), (Object)((Object)SortBy.LAST_USED_DESC)));
        this.filterOptions = (List)ObjectUtils.defaultIfNull(this.filterOptions, Collections.emptyList());
        this.packageNameFilter = StringUtils.defaultString((String)this.packageNameFilter, (String)"");
    }

    public SortBy getSortBy() {
        return this.sortBy;
    }

    public List<FilterOption> getFilterOptions() {
        return this.filterOptions;
    }

    public String getPackageNameFilter() {
        return this.packageNameFilter;
    }

    public String getGroup() {
        return this.group;
    }

    public String getPath() {
        return this.path;
    }

    public Session getSession() {
        return this.session;
    }

    public String getUserID() {
        return this.getSession().getUserID();
    }

    public Long getPageNumber() {
        return this.pageNumber >= 0L ? this.pageNumber : 0L;
    }
}

