/*
 * Decompiled with CFR 0.152.
 */
package pl.ds.websight.packagemanager.rest.group;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import org.jetbrains.annotations.NotNull;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.metatype.annotations.AttributeDefinition;
import org.osgi.service.metatype.annotations.AttributeType;
import org.osgi.service.metatype.annotations.Designate;
import org.osgi.service.metatype.annotations.ObjectClassDefinition;
import pl.ds.websight.packagemanager.dto.GroupDto;
import pl.ds.websight.packagemanager.dto.GroupListDto;
import pl.ds.websight.packagemanager.rest.AbstractRestAction;
import pl.ds.websight.packagemanager.rest.group.GetGroupsRestModel;
import pl.ds.websight.packagemanager.util.JcrPackageUtil;
import pl.ds.websight.rest.framework.RestAction;
import pl.ds.websight.rest.framework.RestActionResult;
import pl.ds.websight.rest.framework.annotations.SlingAction;

@SlingAction(value=SlingAction.HttpMethod.GET)
@Component
@Designate(ocd=Config.class)
public class GetGroupsRestAction
extends AbstractRestAction<GetGroupsRestModel, GroupListDto>
implements RestAction<GetGroupsRestModel, GroupListDto> {
    private Config config;

    @Override
    protected RestActionResult<GroupListDto> performAction(GetGroupsRestModel model) throws RepositoryException {
        return RestActionResult.success((Object)GetGroupsRestAction.listGroups(model.getSession(), this.config.count_limit()));
    }

    private static GroupListDto listGroups(Session session, int limit) throws RepositoryException {
        long allPackagesCount = 0L;
        ArrayList<GroupDto> result = new ArrayList<GroupDto>();
        if (session.nodeExists("/etc/packages/")) {
            Node packageRoot = session.getNode("/etc/packages/");
            long noGroupPackagesCount = JcrPackageUtil.countPackages(packageRoot, limit, false);
            GetGroupsRestAction.addGroup(result, ":no_group", noGroupPackagesCount, limit);
            allPackagesCount += noGroupPackagesCount;
            boolean countPackagesRecursively = true;
            for (Node group : GetGroupsRestAction.getChildGroups(packageRoot)) {
                String groupName = JcrPackageUtil.getGroupIdFromNode(packageRoot, group);
                long packagesCount = JcrPackageUtil.countPackages(group, limit, true);
                GetGroupsRestAction.addGroup(result, groupName, packagesCount, limit);
                if (groupName.contains("/")) continue;
                allPackagesCount += packagesCount;
            }
            result.sort(Comparator.comparing(GroupDto::getName, String::compareToIgnoreCase));
        }
        return new GroupListDto(allPackagesCount, limit, result);
    }

    @NotNull
    private static List<Node> getChildGroups(Node root) throws RepositoryException {
        ArrayList<Node> result = new ArrayList<Node>();
        NodeIterator nodeIterator = root.getNodes();
        while (nodeIterator.hasNext()) {
            Node child = nodeIterator.nextNode();
            String name = child.getName();
            if (".snapshot".equals(name) || JcrPackageUtil.isValidPackageNode(child)) continue;
            result.add(child);
            result.addAll(GetGroupsRestAction.getChildGroups(child));
        }
        return result;
    }

    private static void addGroup(List<GroupDto> groups, String groupName, long packagesCount, long limit) {
        if (packagesCount > 0L) {
            groups.add(new GroupDto(groupName, packagesCount, limit));
        }
    }

    @Override
    protected String getUnexpectedErrorMessage() {
        return "Could not fetch groups";
    }

    @Activate
    private void activate(Config config) {
        this.config = config;
    }

    @ObjectClassDefinition(name="WebSight Package Manager: Get Groups Rest Action Configuration")
    public static @interface Config {
        @AttributeDefinition(name="Package count limit", description="Maximum number of 'count' property returned by 'get-groups' action.", type=AttributeType.INTEGER)
        public int count_limit() default 10000;
    }
}

