/*
 * Decompiled with CFR 0.152.
 */
package pl.ds.websight.packagemanager.rest.packageaction;

import java.io.IOException;
import java.io.PrintWriter;
import java.nio.charset.StandardCharsets;
import java.util.List;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.servlet.Servlet;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.SlingHttpServletResponse;
import org.apache.sling.api.request.RequestParameter;
import org.apache.sling.api.servlets.SlingSafeMethodsServlet;
import org.apache.sling.servlets.annotations.SlingServletPaths;
import org.jetbrains.annotations.NotNull;
import org.osgi.service.component.annotations.Component;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pl.ds.websight.packagemanager.rest.Messages;
import pl.ds.websight.packagemanager.util.PackageLogUtil;

@Component(service={Servlet.class}, property={"sling.servlet.methods=GET", "sling.servlet.extensions=log"})
@SlingServletPaths(value={"/apps/websight-package-manager-service/bin/package"})
public class GetPackageLogServlet
extends SlingSafeMethodsServlet {
    private static final long serialVersionUID = -4296175383327717326L;
    private static final Logger LOG = LoggerFactory.getLogger(GetPackageLogServlet.class);
    static final String ACTION_LOG_EXTENSION = "log";

    protected void doGet(@NotNull SlingHttpServletRequest request, @NotNull SlingHttpServletResponse response) throws IOException {
        block6: {
            response.setContentType("text/plain");
            response.setCharacterEncoding(StandardCharsets.UTF_8.toString());
            response.setHeader("Cache-Control", "no-cache, no-store, must-revalidate");
            response.setHeader("Pragma", "no-cache");
            response.setHeader("Expires", "0");
            String packagePath = GetPackageLogServlet.getPackagePath(request);
            if (packagePath == null) {
                response.sendError(400, "Path must start with '/etc/packages/'");
                return;
            }
            Session session = (Session)request.getResourceResolver().adaptTo(Session.class);
            if (session == null) {
                response.sendError(500, "Could not access user's session");
                return;
            }
            String logPath = PackageLogUtil.getLogPath(packagePath);
            try {
                if (session.nodeExists(packagePath) && session.nodeExists(logPath)) {
                    GetPackageLogServlet.printLogs(response, logPath, session);
                } else {
                    response.sendError(404, Messages.formatMessage("Could not get or access package action logs for package '%s'", packagePath));
                }
            }
            catch (Exception e) {
                LOG.warn("Could not list full logs for package: {}", (Object)packagePath, (Object)e);
                if (response.isCommitted()) break block6;
                response.sendError(500, Messages.formatMessage("Could not get or access package action logs for package '%s'", packagePath));
            }
        }
    }

    private static String getPackagePath(SlingHttpServletRequest request) {
        String path;
        RequestParameter pathParam = request.getRequestParameter("path");
        if (pathParam != null && (path = pathParam.getString()).startsWith("/etc/packages/")) {
            return path;
        }
        return null;
    }

    private static void printLogs(SlingHttpServletResponse response, String logPath, Session session) throws RepositoryException, IOException {
        Node logNode = session.getNode(logPath);
        List<String> fullLog = PackageLogUtil.getLog(logNode, true);
        try (PrintWriter writer = response.getWriter();){
            fullLog.forEach(writer::append);
        }
    }
}

