/*
 * Decompiled with CFR 0.152.
 */
package pl.ds.websight.packagemanager.rest.packageaction;

import javax.annotation.PostConstruct;
import javax.jcr.Session;
import javax.validation.constraints.NotBlank;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.request.RequestParameter;
import org.apache.sling.models.annotations.Default;
import org.apache.sling.models.annotations.Model;
import org.apache.sling.models.annotations.injectorspecific.Self;
import pl.ds.websight.packagemanager.packageoptions.PackageImportOptions;
import pl.ds.websight.packagemanager.rest.PackagePathValidatable;
import pl.ds.websight.packagemanager.util.JcrPackageUtil;

@Model(adaptables={SlingHttpServletRequest.class})
public class PackageActionRestModel
extends PackagePathValidatable {
    @Self
    private SlingHttpServletRequest request;
    @pl.ds.websight.request.parameters.support.annotations.RequestParameter
    @NotBlank(message="Path cannot be blank")
    private @NotBlank(message="Path cannot be blank") String path;
    @pl.ds.websight.request.parameters.support.annotations.RequestParameter
    private String acHandling;
    @pl.ds.websight.request.parameters.support.annotations.RequestParameter
    @Default(booleanValues={true})
    private Boolean extractSubpackages;
    private PackageImportOptions packageImportOptions = PackageImportOptions.DEFAULT;

    @PostConstruct
    protected void init() {
        RequestParameter dryRunParam = this.request.getRequestParameter("dryRun");
        this.packageImportOptions.setDryRun(dryRunParam != null && BooleanUtils.toBoolean((String)dryRunParam.getString()));
        if (StringUtils.isNotBlank((CharSequence)this.acHandling)) {
            this.packageImportOptions.setAcHandling(JcrPackageUtil.toAcHandling(this.acHandling));
        }
        this.packageImportOptions.setExtractSubpackages(this.extractSubpackages);
    }

    public Session getSession() {
        return (Session)this.request.getResourceResolver().adaptTo(Session.class);
    }

    @Override
    public String getPath() {
        return this.path;
    }

    public PackageImportOptions getPackageImportOptions() {
        return this.packageImportOptions;
    }
}

