/*
 * Decompiled with CFR 0.152.
 */
package pl.ds.websight.packagemanager.rest.schedule;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.text.ParseException;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.time.DateFormatUtils;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.sling.event.jobs.JobBuilder;
import org.apache.sling.event.jobs.ScheduleInfo;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pl.ds.websight.packagemanager.util.DateUtil;

public abstract class Schedule
implements Comparable<Schedule> {
    private static final Logger LOG = LoggerFactory.getLogger(Schedule.class);

    @JsonCreator
    public static Schedule createSchedule(@JsonProperty(value="at") String at, @JsonProperty(value="cron") String cron) {
        if (StringUtils.isAllBlank((CharSequence[])new CharSequence[]{at, cron}) || StringUtils.isNotBlank((CharSequence)at) && StringUtils.isNotBlank((CharSequence)cron)) {
            return new InvalidSchedule((Pair)ImmutablePair.of((Object)Arrays.asList(at, cron).toString(), (Object)"Only one not blank value of \"at\" or \"cron\" should be provided"));
        }
        if (StringUtils.isNotBlank((CharSequence)cron)) {
            return new PeriodicSchedule(cron);
        }
        try {
            Date date = DateUtil.parseDateTime(at);
            return date.before(Calendar.getInstance().getTime()) ? new InvalidSchedule((Pair)ImmutablePair.of((Object)DateUtil.format(date), (Object)"The date should be set to future")) : new DateSchedule(date);
        }
        catch (ParseException e) {
            String pattern = DateFormatUtils.ISO_8601_EXTENDED_DATETIME_FORMAT.getPattern();
            String errorMessage = "Could not parse schedule date to format " + pattern;
            LOG.debug(errorMessage, (Throwable)e);
            return new InvalidSchedule((Pair)ImmutablePair.of((Object)at, (Object)errorMessage));
        }
    }

    public abstract boolean matches(ScheduleInfo var1);

    public abstract void addToBuilder(JobBuilder.ScheduleBuilder var1);

    public abstract Pair<String, String> getError();

    @Override
    public abstract int compareTo(@NotNull Schedule var1);

    public boolean equals(Object obj) {
        return super.equals(obj);
    }

    public int hashCode() {
        return super.hashCode();
    }

    private static class InvalidSchedule
    extends Schedule {
        private final Pair<String, String> error;

        private InvalidSchedule(Pair<String, String> error) {
            this.error = error;
        }

        @Override
        public boolean matches(ScheduleInfo scheduleInfo) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void addToBuilder(JobBuilder.ScheduleBuilder scheduleBuilder) {
            throw new UnsupportedOperationException();
        }

        @Override
        public Pair<String, String> getError() {
            return this.error;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            InvalidSchedule that = (InvalidSchedule)o;
            return this.error.equals(that.error);
        }

        @Override
        public int hashCode() {
            return Objects.hash(this.error);
        }

        @Override
        public int compareTo(@NotNull Schedule o) {
            return 1;
        }
    }

    private static class PeriodicSchedule
    extends Schedule {
        private final String expression;

        private PeriodicSchedule(String expression) {
            this.expression = expression;
        }

        @Override
        public boolean matches(ScheduleInfo scheduleInfo) {
            return StringUtils.isNotBlank((CharSequence)scheduleInfo.getExpression()) && scheduleInfo.getExpression().equals(this.expression);
        }

        @Override
        public void addToBuilder(JobBuilder.ScheduleBuilder scheduleBuilder) {
            scheduleBuilder.cron(this.expression);
        }

        @Override
        public Pair<String, String> getError() {
            return null;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            PeriodicSchedule that = (PeriodicSchedule)o;
            return this.expression.equals(that.expression);
        }

        @Override
        public int hashCode() {
            return Objects.hash(this.expression);
        }

        public String toString() {
            return this.expression;
        }

        @Override
        public int compareTo(@NotNull Schedule o) {
            return -1;
        }
    }

    private static class DateSchedule
    extends Schedule {
        private final Date date;

        private DateSchedule(Date date) {
            this.date = date;
        }

        @Override
        public boolean matches(ScheduleInfo scheduleInfo) {
            return scheduleInfo.getAt() != null && scheduleInfo.getAt().equals(this.date);
        }

        @Override
        public void addToBuilder(JobBuilder.ScheduleBuilder scheduleBuilder) {
            scheduleBuilder.at(this.date);
        }

        @Override
        public Pair<String, String> getError() {
            return null;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            DateSchedule that = (DateSchedule)o;
            return this.date.equals(that.date);
        }

        @Override
        public int hashCode() {
            return Objects.hash(this.date);
        }

        public String toString() {
            return DateUtil.format(this.date);
        }

        @Override
        public int compareTo(@NotNull Schedule objectToCompare) {
            if (objectToCompare instanceof DateSchedule) {
                DateSchedule dateScheduleToCompare = (DateSchedule)objectToCompare;
                return dateScheduleToCompare.date.compareTo(this.date);
            }
            return -1;
        }
    }
}

