/*
 * Decompiled with CFR 0.152.
 */
package pl.ds.websight.packagemanager.util;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.sling.api.resource.LoginException;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ResourceResolverFactory;
import org.apache.sling.event.jobs.Job;
import org.apache.sling.event.jobs.JobBuilder;
import org.apache.sling.event.jobs.JobManager;
import org.apache.sling.event.jobs.ScheduleInfo;
import org.apache.sling.event.jobs.ScheduledJobInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pl.ds.websight.packagemanager.JobProperties;
import pl.ds.websight.packagemanager.rest.schedule.Schedule;

public final class JobUtil {
    private static final Logger LOG = LoggerFactory.getLogger(JobUtil.class);
    public static final String PKG_MANAGER_JOB_TOPIC_PREFIX = "pl/ds/websight/packagemanager/packageaction/";

    private JobUtil() {
    }

    public static ResourceResolver getImpersonatedResolver(ResourceResolverFactory factory, String applicantId) {
        try {
            HashMap<String, String> properties = new HashMap<String, String>();
            properties.put("user.impersonation", applicantId);
            return factory.getAdministrativeResourceResolver(properties);
        }
        catch (LoginException e) {
            LOG.error("Could not impersonate resource resolver using applicant user ID: {}", (Object)applicantId, (Object)e);
            return null;
        }
    }

    public static Job findFirstRunningOrQueuedJob(JobManager jobManager, Map<String, Object> jobProperties) {
        return jobManager.findJobs(JobManager.QueryType.ALL, null, 1L, new Map[]{jobProperties}).stream().filter(job -> JobUtil.isPackageManagerJob(job.getTopic())).findFirst().orElse(null);
    }

    public static List<Job> findAllQueuedJobs(JobManager jobManager, Map<String, Object> jobProperties) {
        return jobManager.findJobs(JobManager.QueryType.QUEUED, null, -1L, new Map[]{jobProperties}).stream().filter(job -> JobUtil.isPackageManagerJob(job.getTopic())).collect(Collectors.toList());
    }

    public static List<Job> findRunningAndQueuedJobs(JobManager jobManager, String ... packagesPaths) {
        Map[] packagePathsQueryTemplates = (Map[])Stream.of(packagesPaths).map(JobProperties::asQueryMap).toArray(Map[]::new);
        return jobManager.findJobs(JobManager.QueryType.ALL, null, -1L, packagePathsQueryTemplates).stream().filter(job -> JobUtil.isPackageManagerJob(job.getTopic())).collect(Collectors.toList());
    }

    public static ScheduledJobInfo findScheduledJobWithSchedules(JobManager jobManager, Map<String, Object> scheduleJobProps, List<Schedule> schedules, String jobTopic) {
        return jobManager.getScheduledJobs(jobTopic, 0L, new Map[]{scheduleJobProps}).stream().filter(scheduledJobInfo -> JobUtil.containsEqualSchedules(scheduledJobInfo, schedules)).findFirst().orElse(null);
    }

    public static ScheduledJobInfo getNearestScheduledJob(JobManager jobManager, String packagePath) {
        return JobUtil.getNearestScheduledJobs(jobManager, packagePath).get(packagePath);
    }

    public static Map<String, ScheduledJobInfo> getNearestScheduledJobs(JobManager jobManager, String ... packagesPaths) {
        Map[] packagePathsQueryTemplates = (Map[])Stream.of(packagesPaths).map(JobProperties::asQueryMap).toArray(Map[]::new);
        return jobManager.getScheduledJobs(null, -1L, packagePathsQueryTemplates).stream().filter(jobInfo -> JobUtil.isPackageManagerJob(jobInfo.getJobTopic())).filter(jobInfo -> !jobInfo.isSuspended() && !JobUtil.isScheduleObsolete(jobInfo)).collect(Collectors.groupingBy(JobProperties::getPackagePath, Collectors.minBy(Comparator.comparing(ScheduledJobInfo::getNextScheduledExecution)))).entrySet().stream().filter(entry -> ((Optional)entry.getValue()).isPresent()).collect(Collectors.toMap(Map.Entry::getKey, entry -> (ScheduledJobInfo)((Optional)entry.getValue()).get()));
    }

    private static boolean containsEqualSchedules(ScheduledJobInfo scheduledJobInfo, List<Schedule> schedules) {
        Collection jobInfoSchedules = scheduledJobInfo.getSchedules();
        return jobInfoSchedules.size() >= schedules.size() && jobInfoSchedules.stream().noneMatch(scheduleInfo -> schedules.stream().noneMatch(schedule -> schedule.matches((ScheduleInfo)scheduleInfo)));
    }

    public static ScheduledJobInfo findFirstScheduledJob(JobManager jobManager, Map<String, Object> scheduleJobProps, String scheduleId) {
        return jobManager.getScheduledJobs(null, 0L, new Map[]{scheduleJobProps}).stream().filter(scheduledJobInfo -> JobUtil.isPackageManagerJob(scheduledJobInfo.getJobTopic())).filter(scheduledJobInfo -> JobUtil.getScheduleId(scheduledJobInfo).equals(scheduleId)).findFirst().orElse(null);
    }

    public static String getScheduleId(ScheduledJobInfo scheduledJobInfo) {
        return scheduledJobInfo.hashCode() + "";
    }

    public static List<ScheduledJobInfo> findAllScheduledJobs(JobManager jobManager) {
        return JobUtil.findAllScheduledJobs(jobManager, null).stream().filter(scheduledJobInfo -> JobUtil.isPackageManagerJob(scheduledJobInfo.getJobTopic())).filter(JobUtil::hasValidProperties).collect(Collectors.toList());
    }

    public static List<ScheduledJobInfo> findAllScheduledJobs(JobManager jobManager, Map<String, Object> scheduledJobProperties) {
        return jobManager.getScheduledJobs(null, 0L, new Map[]{scheduledJobProperties}).stream().filter(scheduledJobInfo -> JobUtil.isPackageManagerJob(scheduledJobInfo.getJobTopic())).collect(Collectors.toList());
    }

    private static boolean isPackageManagerJob(String jobTopic) {
        return jobTopic.startsWith(PKG_MANAGER_JOB_TOPIC_PREFIX);
    }

    public static JobBuilder.ScheduleBuilder createScheduleBuilder(String jobTopic, Map<String, Object> properties, JobManager jobManager) {
        return jobManager.createJob(jobTopic).properties(properties).schedule();
    }

    public static boolean addSchedule(JobBuilder.ScheduleBuilder scheduleBuilder) {
        ArrayList errorMessages = new ArrayList();
        ScheduledJobInfo addedSchedule = scheduleBuilder.add(errorMessages);
        if (addedSchedule == null) {
            LOG.warn("Could not add schedule due to: {}", errorMessages);
            return false;
        }
        return true;
    }

    private static boolean hasValidProperties(ScheduledJobInfo scheduledJobInfo) {
        return JobProperties.fetch(scheduledJobInfo) != null;
    }

    public static boolean isScheduleObsolete(ScheduledJobInfo scheduledJobInfo) {
        Date nextScheduledExecution = scheduledJobInfo.getNextScheduledExecution();
        return nextScheduledExecution == null || !scheduledJobInfo.isSuspended() && nextScheduledExecution.before(Calendar.getInstance().getTime());
    }
}

