/*
 * Decompiled with CFR 0.152.
 */
package pl.ds.websight.packagemanager.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.TreeMap;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.jcr.Node;
import javax.jcr.Property;
import javax.jcr.PropertyIterator;
import javax.jcr.RepositoryException;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.sling.api.resource.ModifiableValueMap;
import org.apache.sling.api.resource.PersistenceException;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ResourceUtil;
import org.apache.sling.api.resource.ValueMap;
import org.apache.sling.commons.osgi.PropertiesUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class PackageLogUtil {
    private static final Logger LOG = LoggerFactory.getLogger(PackageLogUtil.class);
    public static final String PN_LOG_ENTRY_PREFIX = "entries";
    public static final int MAX_ENTRY_CAPACITY = 1000;
    public static final String PN_FIRST_LOG_ENTRY = "entries0-1000";
    public static final String PN_APPLICANT_ID = "applicantId";
    public static final String PN_LOG_AUTHOR_SIGN = "logAuthorId";
    public static final String PN_LOG_PACKAGE_ACTION_TYPE = "logPackageActionType";
    public static final String RT_LOG_INTERMEDIATE_NODES = "sling:Folder";
    public static final String LOG_PATH_PREFIX = "/var/websight/websight-package-manager-service/logs/";

    private PackageLogUtil() {
    }

    public static String increaseRange(String range) {
        ImmutablePair<Long, Long> rangeLimits = PackageLogUtil.getRangeLimits(range);
        long lowerLimit = (Long)rangeLimits.getLeft();
        long upperLimit = (Long)rangeLimits.getRight();
        return String.format("%d-%d", lowerLimit += lowerLimit == 0L ? 1001L : 1000L, upperLimit += 1000L);
    }

    public static ImmutablePair<Long, Long> getRangeLimits(String range) {
        String[] limits = StringUtils.split((String)range, (String)"-", (int)2);
        if (limits.length != 2) {
            return PackageLogUtil.getPreIncrementedLimits();
        }
        try {
            return ImmutablePair.of((Object)NumberUtils.createLong((String)limits[0]), (Object)NumberUtils.createLong((String)limits[1]));
        }
        catch (NumberFormatException e) {
            LOG.debug("Could not get limits of log range", (Throwable)e);
            return PackageLogUtil.getPreIncrementedLimits();
        }
    }

    private static ImmutablePair<Long, Long> getPreIncrementedLimits() {
        return ImmutablePair.of((Object)Math.negateExact(1001L), (Object)0L);
    }

    public static String removeLogEntryNamePrefix(String propertyName) {
        return propertyName.substring(PN_LOG_ENTRY_PREFIX.length());
    }

    public static void putLog(ModifiableValueMap logValueMap, String range, List<String> entry) {
        if (entry.isEmpty()) {
            return;
        }
        String mergedLogEntry = entry.stream().map(logLine -> StringUtils.appendIfMissing((String)logLine, (CharSequence)"\n", (CharSequence[])new CharSequence[0])).reduce("", String::concat);
        logValueMap.put((Object)(PN_LOG_ENTRY_PREFIX + range), (Object)mergedLogEntry);
    }

    public static boolean isLogsAuthorDifferent(String newAuthorJobId, ValueMap valueMap) {
        return !newAuthorJobId.equals(valueMap.get(PN_LOG_AUTHOR_SIGN, String.class));
    }

    public static List<String> getLogEntry(ValueMap logValueMap, String logEntryName) {
        return PackageLogUtil.splitLogEntry((String)logValueMap.get(logEntryName, String.class));
    }

    public static List<String> getLog(Node logNode, boolean fullLog) throws RepositoryException {
        if (!logNode.hasProperty(PN_FIRST_LOG_ENTRY)) {
            return Collections.emptyList();
        }
        PropertyIterator properties = logNode.getProperties();
        return fullLog ? PackageLogUtil.getFullLog(properties) : PackageLogUtil.getLogTail(properties, logNode.getProperty(PN_FIRST_LOG_ENTRY));
    }

    private static List<String> getFullLog(PropertyIterator properties) throws RepositoryException {
        TreeMap<Long, List<String>> logEntriesMap = new TreeMap<Long, List<String>>();
        while (properties.hasNext()) {
            List<String> logEntry;
            Property property = properties.nextProperty();
            if (!PackageLogUtil.isLogEntry(property.getName()) || (logEntry = PackageLogUtil.getLogEntry(property)) == null) continue;
            logEntriesMap.put(PackageLogUtil.getLowerLimit(property), logEntry);
        }
        return logEntriesMap.values().stream().flatMap(Collection::stream).collect(Collectors.toList());
    }

    private static List<String> getLogTail(PropertyIterator properties, Property firstLogNode) throws RepositoryException {
        Property logTailPredecessor = null;
        Property logTailProp = firstLogNode;
        while (properties.hasNext()) {
            Property property = properties.nextProperty();
            if (!PackageLogUtil.isLogEntry(property.getName()) || PackageLogUtil.getLowerLimit(property) <= PackageLogUtil.getLowerLimit(logTailProp)) continue;
            logTailPredecessor = logTailProp;
            logTailProp = property;
        }
        return PackageLogUtil.getMaxFilledLogTail(logTailPredecessor, logTailProp);
    }

    public static boolean isLogEntry(String propName) {
        return propName.startsWith(PN_LOG_ENTRY_PREFIX);
    }

    private static long getLowerLimit(Property logProperty) throws RepositoryException {
        return Optional.of(logProperty.getName()).map(PackageLogUtil::removeLogEntryNamePrefix).map(range -> range.split("-")).filter(limits -> ((String[])limits).length == 2).map(limits -> limits[0]).map(lowerLimit -> {
            try {
                return Long.parseUnsignedLong(lowerLimit);
            }
            catch (NumberFormatException e) {
                LOG.warn("Could not get lower limit of one of log entries", (Throwable)e);
                return 0L;
            }
        }).orElse(0L);
    }

    private static List<String> getMaxFilledLogTail(Property logTailPredecessor, Property logTailProp) throws RepositoryException {
        List<String> logTail = PackageLogUtil.getLogEntry(logTailProp);
        if (logTailPredecessor != null && logTail != null && logTail.size() < 1000) {
            return Optional.ofNullable(PackageLogUtil.getLogEntry(logTailPredecessor)).filter(predecessorEntry -> predecessorEntry.size() == 1000).map(predecessorEntry -> predecessorEntry.subList(logTail.size(), 1000)).map(Collection::stream).map(extendedLogsStream -> Stream.concat(extendedLogsStream, logTail.stream())).orElseGet(logTail::stream).collect(Collectors.toCollection(ArrayList::new));
        }
        return logTail;
    }

    private static List<String> getLogEntry(Property logProp) throws RepositoryException {
        return PackageLogUtil.splitLogEntry(PropertiesUtil.toString((Object)logProp.getValue(), null));
    }

    public static List<String> splitLogEntry(String mergedLogEntry) {
        return mergedLogEntry != null ? new ArrayList<String>(Arrays.asList(mergedLogEntry.split("(?<=\n)"))) : null;
    }

    public static ModifiableValueMap getOrCreatePackageLogMap(ResourceResolver resolver, String destinationPath) {
        try {
            Resource actionLog = ResourceUtil.getOrCreateResource((ResourceResolver)resolver, (String)destinationPath, Collections.singletonMap("jcr:primaryType", "nt:unstructured"), (String)RT_LOG_INTERMEDIATE_NODES, (boolean)false);
            return (ModifiableValueMap)actionLog.adaptTo(ModifiableValueMap.class);
        }
        catch (PersistenceException e) {
            LOG.warn("Could not access action log resource in: {}", (Object)destinationPath, (Object)e);
            return null;
        }
    }

    public static void updateActionInfo(String logActionType, String applicantId, ModifiableValueMap logValueMap) {
        logValueMap.put((Object)PN_LOG_PACKAGE_ACTION_TYPE, (Object)logActionType);
        logValueMap.put((Object)PN_APPLICANT_ID, (Object)applicantId);
    }

    public static String getLogPath(String packagePath) {
        return LOG_PATH_PREFIX + StringUtils.removeStart((String)packagePath, (String)"/etc/packages/");
    }
}

