/*
 * Decompiled with CFR 0.152.
 */
package pl.ds.websight.packagemanager;

import java.util.List;
import java.util.OptionalLong;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import org.apache.jackrabbit.vault.packaging.JcrPackage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PackageFinder {
    private static final Logger LOG = LoggerFactory.getLogger(PackageFinder.class);
    public static final int PACKAGES_PER_PAGE = 25;

    private PackageFinder() {
    }

    public static long getNumberOfPages(long allPackagesAmount) {
        return allPackagesAmount % 25L == 0L ? allPackagesAmount / 25L : allPackagesAmount / 25L + 1L;
    }

    public static long getOffset(long pageNumber) {
        long validatedPageNr = pageNumber - 1L > 0L ? pageNumber - 1L : 0L;
        return validatedPageNr * 25L;
    }

    public static OptionalLong findPageWithPackage(String path, List<JcrPackage> packages) {
        long packageIndex = -1L;
        for (int i = 0; i < packages.size(); ++i) {
            try {
                JcrPackage jcrPackage = packages.get(i);
                Node packageNode = jcrPackage.getNode();
                if (packageNode == null || !path.equals(packageNode.getPath())) continue;
                packageIndex = i;
                break;
            }
            catch (RepositoryException e) {
                LOG.warn("Could not get Node for JCR package", (Throwable)e);
            }
        }
        return packageIndex > -1L ? OptionalLong.of(PackageFinder.getNumberOfPages(packageIndex + 1L)) : OptionalLong.empty();
    }
}

